/* $Header: /cvs/gnome/gIDE/src/gdbio.c,v 1.2 1999/11/06 17:45:39 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <fcntl.h>
#include <glib.h> 


gint main( gint argc, gchar *argv[] )
{
	gchar *args[4];
	gchar *pipe;
	gint fh;
	gchar buf[100];
	struct sockaddr_un sock;

	if( argc < 3 )
	{
		printf("%s: this program is for gide-internal use only!\n",argv[0] );
		exit(-1);
	} 

	/* handle commandline parameters */
	args[0] = argv[1];	/* gdb */
	args[1] = g_strdup( "-nx" ); 
	args[2] = g_strdup( "-fullname" );
	args[3] = NULL;
	pipe = argv[2];

	fh = socket( AF_UNIX, SOCK_STREAM, 0 );
	if( fh < 0 )
	{
		perror( "socket" );
		exit(-1);

	}

	sock.sun_family = AF_UNIX;
	strcpy( sock.sun_path, pipe );
	if( connect( fh, (struct sockaddr *)&sock, sizeof(struct sockaddr_un) ) < 0 )
	{
		perror( "connect" );
		exit(-1);
	}

	/* maybe we should send the pid first? */
	sprintf( buf, "%u", getpid() );
	write( fh, buf, strlen(buf)+1 ); 

   	close (0); dup (fh);  /* set the stdin to the in pipe */
   	close (1); dup (fh);  /* set the stdout to the out pipe */
	close (2); dup (fh);  /* set the stderr to the out pipe */

	/* run gdb */
   	if( execvp (args[0], args) < 0 )
	{
		perror( "execvp" );
		exit(-1);
	}

	return( 0 );
}
