#include "available-stubs.h"

#ifdef HAVE_SYS_TIMES_H
#include <sys/times.h>
#include "checker_api.h"

#ifdef HAVE_times
/* From `/usr/include/sys/times.h:31'.  */
clock_t chkr_stub_times (struct tms *t) __asm__ (CHKR_PREFIX ("times"));
clock_t
chkr_stub_times (struct tms *t)
{
  clock_t res;

  stubs_chkr_check_addr (&t->tms_utime, sizeof (t->tms_utime),
			 CHKR_TW, "b->tms_utime");
  stubs_chkr_check_addr (&t->tms_stime, sizeof (t->tms_stime),
			 CHKR_TW, "b->tms_stime");
  stubs_chkr_check_addr (&t->tms_cutime, sizeof (t->tms_cutime),
			 CHKR_TW, "b->tms_cutime");
  stubs_chkr_check_addr (&t->tms_cstime, sizeof (t->tms_cstime),
			 CHKR_TW, "b->tms_cstime");

  res = times (t);
  if (res != -1)
    {
      stubs_chkr_check_addr (&t->tms_utime, sizeof (t->tms_utime),
			     CHKR_WO, "b->tms_utime");
      stubs_chkr_check_addr (&t->tms_stime, sizeof (t->tms_stime),
			     CHKR_WO, "b->tms_stime");
      stubs_chkr_check_addr (&t->tms_cutime, sizeof (t->tms_cutime),
			     CHKR_WO, "b->tms_cutime");
      stubs_chkr_check_addr (&t->tms_cstime, sizeof (t->tms_cstime),
			     CHKR_WO, "b->tms_cstime");
    }

  return res;
}
#endif /* HAVE_times */

#endif /* HAVE_SYS_TIMES_H */
