-- Copyright 1998 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GTK_WINDOW - top-level window"
	version: "v 0.3.3 GTK+ 1.2.x"
	author: "Richie Bielak"
	changed: "??"
	cvs: "$Id: gtk_window.e,v 1.7 1999/10/03 02:07:19 richieb Exp $"

class GTK_WINDOW

-- A top level window
--
-- Signals (from gtkwindow.c):
--    "set_focus"

inherit

	GTK_BIN
		rename
			window as gdk_window,
			widget as window
		end

	GTK_WINDOW_EXTERNALS
		undefine
			copy, is_equal
		end

	GTK_CONSTANTS
		undefine
			copy, is_equal
		end

creation

	make_top_level,
	make_from_pointer

feature

	set_title (title: STRING) is
			-- set the title in the window decoration
		require
			valid_title: title /= Void
		do
			-- gtk_window_set_title (window, $(title.to_c))
			npc.np_gtk_window_set_title (window, title)
		end

	set_policy (allow_shrink, allow_grow, auto_shrink: BOOLEAN) is
			-- set the resizing policy
		do
			gtk_window_set_policy (window, allow_shrink, allow_grow, auto_shrink)
		end

feature {NONE}

	make_top_level is
			-- creation procedure
		do
			window := gtk_window_new (GTK_WINDOW_TOPLEVEL);
			register_widget
		ensure
			window /= default_pointer
		end

							 

end
