-- Copyright 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GTK_OPTION_MENU"
	author: "Daniel Elphick"

class GTK_OPTION_MENU

-- an option menu is a button which when pressed displays a menu of options.
-- Selection one changes the button's label to that option.
inherit

	GTK_WIDGET

	GTK_OPTION_MENU_EXTERNALS
		undefine
			is_equal, copy
		end

	EGTK_NON_PORTABLE
		undefine
			is_equal, copy
		end

creation

	make

feature

	get_menu: GTK_MENU is
		do
			Result := menu
		end

	set_menu(new_menu: GTK_MENU) is
		require
			valid_menu: new_menu /= Void
		do
			menu := new_menu
			gtk_option_menu_set_menu(widget, menu.widget)
		end

	remove_menu is
		do
			gtk_option_menu_remove_menu(widget)
			menu := Void
		end

	set_history(index: INTEGER) is
		do
			gtk_option_menu_set_history(widget, index)
		end

	set_menu_strings(strings: ARRAY[STRING]) is
		local
			i: INTEGER
			new_menu: GTK_MENU
			menu_item: GTK_MENU_ITEM
		do
			!!new_menu.make
			from
				i := strings.lower
			until
				i > strings.upper
			loop
				!!menu_item.make_with_label(strings @ i)
				new_menu.append(menu_item)
				menu_item.show
				i := i + 1
			end
			set_menu(new_menu)
		end

feature {NONE}

	menu: GTK_MENU

	make is
			-- Create a new option menu widget
		do
			widget := gtk_option_menu_new
			register_widget
			--!!menu.make_from_pointer(gtk_option_menu_get_menu(widget))
		end

end -- GTK_OPTION_MENU
