indexing
	description: "Gtk Eiffel Library environment class represents the gtk environment"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:37:42 $"
	revision: "$Revision: 1.1.1.1 $"

class
	GTK_ENVIRONMENT

inherit
	GTK_ENUMS

feature -- Initialization

	gtk_init is
		once
			c_gtk_init
			c_event_marshaler_init ($Current, $event_marshaler)
		end

	gtk_main is
		once
			c_gtk_main
		end

	objects_by_c_pointer: HASH_TABLE [GTK_ANY, POINTER] is
			-- gel objects hashed on the C pointer to the corresponding gtk object
		once
			create Result.make (0)
		end

feature -- Event handling

	event_marshaler (callback_id: INTEGER) is
		local
			cbd: GTK_CALLBACK_DATA
		do
			print ("callback ")
			if callback_id > 0 then
				print (callback_id); print ("%N")
				cbd := callback_data @ callback_id
				cbd.command.execute (cbd.source)
			else
				print (-callback_id); print ("detached%N")
				callback_data.put_i_th (Void, -callback_id)
			end
		end

	callback_data: ARRAYED_LIST [GTK_CALLBACK_DATA] is
			-- command instances indexed on unique ids
		once
			create Result.make (0)
		end

	new_callback_id (a_callback_data: GTK_CALLBACK_DATA): INTEGER is
		do
			callback_data.extend (a_callback_data)
			Result := callback_data.count
		end

feature -- Conversion

	e2c (o: ANY): POINTER is
			-- Try to convert any eiffel object into
			-- a useful C structrue.
			-- Supports:
			--     STRING -> char*
			--     SEQUENCE [STRING] -> char**
		local
			a: ANY
			s: STRING
			sl: SEQUENCE [STRING]
			c_sl: ARRAY [POINTER]
		do
			s ?= o
			sl ?= o
			if s /= Void then
				a ?= s.to_c
			elseif sl /= Void then
				create c_sl.make (1, sl.count)
				from sl.start
				until sl.after
				loop
					a ?= sl.item.to_c
					c_sl.put ($a, sl.index)
					sl.forth
				end
				a ?= c_sl.to_c
			end
			if a /= Void then
				Result := p2p($a)
			end
		end

	p2p (p: POINTER): POINTER is
			-- Result := $x
			-- causes a syntax error
			-- this is a workaround
		do
			Result := p
		end

feature {NONE} -- Externals

	c_gtk_init is
		external
			"C | %"gel.h%""
		end

	c_gtk_main is
		external
			"C | <gtk/gtk.h>"
		alias
			"gtk_main"
		end

	c_event_marshaler_init (a_gtk_environment, a_event_marshaler: POINTER) is
		external
			"C | %"gel.h%""
		end

	c_signal_connect (a_object, a_name: POINTER; callback_id: INTEGER): INTEGER is
		external
			" C | %"gel.h%""
		end

end -- class GTK_ENVIRONMENT


--!-----------------------------------------------------------------------------
--! GEL, the GTK Eiffel Library
--! Copyright (C) 1999, Sam O'Connor, Sam@OConnor.net
--!
--! This library is free software; you can redistribute it and/or
--! modify it under the terms of the GNU Library General Public
--! License as published by the Free Software Foundation; either
--! version 2 of the License, or (at your option) any later version.
--!
--! This library is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
--! Library General Public License for more details.
--!
--! You should have received a copy of the GNU Library General Public
--! License along with this library; if not, write to the Free
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!-----------------------------------------------------------------------------
