indexing
	description: "Linked list of GTK_CLASS objects"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/04 08:47:19 $"
	revision: "$Revision: 1.2 $"

class

	GTK_CLASSES

inherit

	LINKED_LIST [GTK_CLASS]
		rename
			make as linked_list_make
		redefine
			extend
		end

creation

	make

feature

	make (gu: GTK_UNIVERSE) is
		do
			linked_list_make
			gtk_universe := gu
			create orphans.make ("ORPHANS")
			orphans.set_h_file_name ("")
			orphans.set_gtk_universe (gtk_universe)
			create glib_externals.make ("GLIB")
			glib_externals.set_h_file_name ("glib.h")
			glib_externals.set_gtk_universe (gtk_universe)
			create gdk_externals.make ("GDK")
			gdk_externals.set_h_file_name ("gdk.h")
			gdk_externals.set_gtk_universe (gtk_universe)
			create gtk_externals.make ("GTK_EXTERNALS")
			gtk_externals.set_h_file_name ("gtk.h")
			gtk_externals.set_gtk_universe (gtk_universe)
		end

	class_by_name (nm: STRING): GTK_CLASS is
			-- class called `nm'
		local
			i: INTEGER
			found: BOOLEAN
		do
			i := index
			found := False
			from start until after or found loop
				if item.name.is_equal (nm) then
					Result := item
					Found := true
				end
				forth
			end
			go_i_th (i)
		end

	extend (v: like item) is
		do
			Precursor {LINKED_LIST} (v)
			v.set_gtk_universe (gtk_universe)
		end

	is_class (name: STRING): BOOLEAN is
			-- is `name' a class name
		local
			i: INTEGER
		do
			i := index
			from start until after loop
				if item.name.is_equal (name) then
					Result := True
				end
				forth
			end
			go_i_th (i)
		end

--	set_new_h_file_name (h_file_name: STRING) is
--		local
--			i: INTEGER
--		do
--			i := index
--			from start until after loop
--				if item.h_file_name = Void then
--					item.set_h_file_name (h_file_name)
--				end
--				forth
--			end
--			go_i_th (i)
--		end

	attach_prototypes (pts: C_PROTOTYPES) is
			-- Compute which class each prototype belongs to
			-- Note: this is currently a bit broken.
			-- gtk_binding_* is interpreted as being feature ding_*
			-- of class gtk_bin
			-- Should be changed to look for maximal matching class name.
			-- This will work but is not perfect.
			-- A class GtkButtonBox with feature size will clash
			-- with a class GtkButton with feature box_size.
			-- This does not occur in the source as far as I can see
			-- but a better way needs to be found.
		local
			class_name: STRING
			attached: BOOLEAN
		do
			from
				pts.start
			until
				pts.after
			loop
				from
					start
					attached := False
				until
					after
					or attached
				loop
					if item.h_file_name.is_equal (pts.item.file_name) then
						class_name := clone (item.scored_name)
						class_name.append_character ('_')
						if pts.item.name.substring_index (class_name, 1) = 1 then
							item.prototypes.extend (pts.item)
							attached := True
						end
					end
					forth
				end
				if not attached then
					if pts.item.name.substring_index ("g_", 1) = 1 
					or pts.item.name.substring_index ("glib_", 1) = 1  then
						glib_externals.prototypes.extend (pts.item)
					elseif pts.item.name.substring_index ("gdk_", 1) = 1 then
						gdk_externals.prototypes.extend (pts.item)
					elseif pts.item.name.substring_index ("gtk_", 1) = 1 then
						gtk_externals.prototypes.extend (pts.item)
					else
						orphans.prototypes.extend (pts.item)
					end
				end
				pts.forth
			end
		end

	glib_externals: GTK_CLASS
		-- class for glib prototypes

	gdk_externals: GTK_CLASS
		-- class for gdk prototypes

	gtk_externals: GTK_CLASS
		-- class for gtk prototypes that do not belong to a class

	orphans: GTK_CLASS
		-- class for prototypes with no other class

	gtk_universe: GTK_UNIVERSE

feature -- Output

        dump (dir: DIRECTORY; status: STRING; ticker: TICKER) is
                        -- Dump all class texts to files in `dir'.
                do
                	orphans.dump (dir,status)
                	glib_externals.dump (dir,status)
                	gdk_externals.dump (dir,status)
                	gtk_externals.dump (dir,status)
			ticker.tick
                        from start until after loop
                                item.dump (dir, status)
                                ticker.tick
                                forth
                        end
                end

end -- class GTK_CLASSES


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
