indexing
	description: "GEL class"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/04 08:47:19 $"
	revision: "$Revision: 1.2 $"

class
	GEL_CLASS

creation

	make

feature -- Initialization

	make (new_name: STRING) is
			-- Initilize with name
		require
			valid_new_name: new_name /= Void
			new_name_not_empty: new_name.count > 0
		do
			create attributes.make
			create features.make
			create creation_features.make
			name := clone (new_name)
			name.to_upper
			author := "Generated by the GOTE"
		ensure
			name_set: new_name.is_equal (name)
		end

feature -- Access

	name: STRING
			-- GEL_CLASS_NAME

	parent_name: STRING

	set_parent_name (pn: STRING) is
		do
			parent_name := pn
		end

	parent: GEL_CLASS
			-- Class that `Current' class inherits

	set_parent (new_parent: GEL_CLASS) is 
		require
			valid_parent: new_parent /= Void
		do
			parent := new_parent
		ensure
			parent_set: parent = new_parent
		end

	externals_name: STRING
			-- Name of class containing C externals for use by this class.

	set_externals_name (en: STRING) is
		do
			externals_name := clone (en)
			externals_name.to_upper
		end

	signals: LINKED_LIST [STRING]

	set_signals (l: LINKED_LIST [STRING]) is
		do
			signals := l
		end

	events: LINKED_LIST [STRING]

	set_events (l: LINKED_LIST [STRING]) is
		do
			events := l
		end

	feature_names: LINKED_LIST [STRING] is
			-- names of features of `Current'
		local
			i: INTEGER
		do
			create Result.make
			i := features.index
			from features.start
			until features.after
			loop
				if features.item.short_name /= Void then
					Result.extend (features.item.short_name)
				else
					Result.extend (features.item.name)
				end
				features.forth
			end
			features.go_i_th (i)
		end

	renamed_features: HASH_TABLE [STRING, STRING] is
			-- Features inhertied and renamed
			-- mapped onto the new names.
			-- The renaming policy is:
			--  If some feature bar is inherited from class foo
			--     and clashes with either the name or short_name of
			--     a feature of the Current class,
			--  Then the inherited feature is renamed foo_bar
			--  (bar need not be defined in foo, it may be defined
			--   in some ancestor of foo)
			-- The algorithm is recursive, building a list of feature
			-- names back to the root of the inheritance tree and taking
			-- into account any renamings that happen along the way.
			-- As everything is set up to inherit ANY clashes with features
			-- from ANY are handled.
		local
			fs: LINKED_LIST [STRING]
			n: STRING
		do
			create Result.make (0)
			if parent /= Void then
				create fs.make
				fs.append (parent.inherited_features)
				fs.append (parent.feature_names)
				from fs.start until fs.after loop
					if has_feature (fs.item) then
						n := clone (fs.item)
						n.prepend ("_")
						n.prepend (parent.name)
						n.to_lower
						Result.extend (fs.item, n)
					end
					fs.forth
				end
			end
		end

	inherited_features: LINKED_LIST [STRING] is
			-- features inhertied from `parent'
		local
			i: INTEGER
			n: STRING
		do
			create Result.make
			if parent /= Void then
				Result.append (parent.inherited_features)
				Result.append (parent.feature_names)

				from Result.start until Result.after loop
					if has_feature (Result.item) then
						n := clone (Result.item)
						n.prepend ("_")
						n.prepend (parent.name)
						n.to_lower
						Result.replace (n)
					end
					Result.forth
				end
			end
		end

	description: STRING

	set_description (new_description: STRING) is
		do
			description := new_description
		end

	author: STRING

	set_author (new_author: STRING) is
		do
			author := new_author
		end

	status: STRING

	set_status (new_status: STRING) is
		do
			status := new_status
		end

	attributes: LINKED_LIST [GEL_ARGUMENT]

	features: GEL_FEATURES
			-- Features of `Current' class

	has_feature (n: STRING): BOOLEAN is
			-- Does `Current' have a feature called `n'
		local
			i: INTEGER
		do
			Result := False
			i := features.index
			from features.start
			until
				features.after
				or Result = True
			loop
				if n.is_equal (features.item.name) then
					Result := True
				end
				if features.item.short_name /= Void then
					if n.is_equal (features.item.short_name) then
						Result := True
					end
				end
				features.forth
			end
			features.go_i_th (i)
		end

	creation_features: LINKED_LIST [STRING]
			-- Creation features of `Current' class

feature -- Output

	dump (dir: DIRECTORY) is
			-- Dump eiffel text to a file in `dir'
		local 
			f: RAW_FILE
			n: STRING
		do
				n := clone (name)
				n.to_lower
				n.append (".e")
				n.prepend_character (operating_environment.directory_separator)
				n.prepend (dir.name)
                                create f.make (n)
                                f.open_write
                                f.put_string (text)
                                f.close
		end

feature -- Conversion to Eiffel text

	text: STRING is
			-- Eiffel text of `Current' gel class
		local
			r: FMT_STRING
			s: STRING
		do
			create r.make
			Result := r
			r.append ("indexing%N^%Nclass%N%T^%N%N")
			r.inject (indexing_text)
			r.inject (name)
			r.append (inherit_text)
			r.append (create_text)
			r.append ("feature%N%N")
			r.append (attributes_text)
			r.append (features_text)
			r.append (signals_text)
			if externals_name /= Void then
				r.append ("feature -- Implementation%N%N")
				r.append ("%T^: ^ is%N%T%Tonce%N%T%T%Tcreate Result%N%T%Tend%N%N")
				s := clone (externals_name)
				s.to_lower
				r.inject (s)
				r.inject (externals_name)
			end
			r.append ("end -- class ^%N")
			if status /= Void then
				r.append (status)
				r.append ("%N")
			end
			r.inject (name)
		end

	indexing_text: STRING is
			-- Eiffel text of indexing clause
		do
			create {FMT_STRING} Result.make
			if description /= Void then
				Result.append ("%Tdescription: %"")
				Result.append (description)
				Result.append ("%"%N")
			end
			if author /= Void then
				Result.append ("%Tauthor: %"")
				Result.append (author)
				Result.append ("%"%N")
			end
			if status /= Void then
				Result.append ("%Tstatus: %"See important notice at end of file.%"%N")
			end
		end

	inherit_text: STRING is
			-- Eiffel text of inherit clause
		do
			create {FMT_STRING} Result.make
			if parent /= Void then
				Result.append ("inherit%N")
				Result.append ("%T")
				Result.append (parent.name)
				Result.append ("%N")
				Result.append (rename_text)
				Result.append ("%N")
				--if externals_name /= Void then
				--	Result.append ("%T")
				--	Result.append (externals_name)
				--	Result.append ("%N%T%Texport%N%T%T%T{NONE} all%N%T%Tend%N%N")
				--end
			end
		end

	rename_text: STRING is
			-- Eiffel text of rename clause
		local
			rf: HASH_TABLE [STRING, STRING]
		do
			create {FMT_STRING} Result.make
			rf := renamed_features
			if rf.count > 0 then
				Result.append("%T%Trename%N")
				from rf.start until rf.after loop
					Result.append ("%T%T%T")
					Result.append (rf.item_for_iteration)
					Result.append (" as ")
					Result.append (rf.key_for_iteration)
					rf.forth
					if not rf.after then
						Result.append (",%N")
					end
				end
				Result.append("%N%T%Tend%N")
			end
		end

	create_text: STRING is
			-- Eiffel text of create clause

		local
			i: INTEGER
			cfs: LINKED_LIST [STRING]
		do
			create {FMT_STRING} Result.make

			create cfs.make
			cfs.append (creation_features)

			from features.start until features.after loop
				if features.item.is_creation then
					if features.item.short_name /= Void then
						cfs.extend (features.item.short_name)
					else
						cfs.extend (features.item.name)
					end
				end
				features.forth
			end

			if cfs.count /= 0 then
				Result.append ("create%N")
				
				from
					cfs.start
					i := cfs.index
				until
					cfs.after
				loop
					Result.append ("%T")
					Result.append (cfs.item)
					if cfs.index /= cfs.count then
						Result.append (",%N")
					end
					cfs.forth
				end
				cfs.go_i_th (i)
				Result.append ("%N%N")
			end
		end

	attributes_text: STRING is
			-- Eiffel text of attributes
		local
			i: INTEGER
			r: FMT_STRING
		do
			create {FMT_STRING} r.make
			Result := r
			i := attributes.index
			from attributes.start
			until attributes.after
			loop
				r.append ("%T^: ^%N%N")
				r.inject (attributes.item.name)
				r.inject (attributes.item.type)
				attributes.forth
			end
			attributes.go_i_th (i)
		end

	features_text: STRING is
			-- Eiffel text of features
		local
			i: INTEGER
		do
			create Result.make (0)
			i := features.index
			from features.start
			until features.after
			loop
				Result.append (features.item.text)
				features.forth
			end
			features.go_i_th (i)
		end

	signals_text: STRING is
			-- Eiffel text of signal connection features
		local
			l: LINKED_LIST [STRING]
			s: FMT_STRING
		do
			l := clone (signals)
			l.append (events)
			create s.make
			Result := s
			from l.start
			until l.after
			loop
				s.append ("%Tconnect_^_signal (function: POINTER; data: POINTER): INTEGER is%N")
				s.inject (l.item)
				s.append ("%T%T%T-- Connect `function' to the %"^%" signal.%N")
				s.inject (l.item)
				s.append ("%T%T%T-- `data' will be passed back when `function' is called.%N")
				s.append ("%T%Tdo%N%T%T%TResult := c_gtk_externals.gtk_signal_connect (c_object, e2c(%"^%"), function, data)%N%T%Tend%N%N")
				s.inject (l.item)
				l.forth
			end
		end

invariant

	valid_name: name /= Void

	valid_features: features /= Void

end -- class GTK_CLASS


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
