indexing
	description: "GEL argument"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:45 $"
	revision: "$Revision: 1.1.1.1 $"

class

	GEL_ARGUMENT

creation

	make

feature -- Initialization

	make (new_name, new_type: STRING) is
		require
			valid_new_name: new_name /= Void
			valid_new_type: new_type /= Void
		do
			name := clone (new_name)
			name.to_lower
			type := clone (new_type)
			type.to_upper
		end

feature -- Access

	name: STRING
			-- GEL_CLASS_NAME

	type: STRING
			-- Eiffel return type

	set_type (a_type: STRING) is
		do
			type := clone (a_type)
		end

invariant

	valid_name: name /= Void

	valid_type: type /= Void

end -- class GEL_ARGUMENT


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
