indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GtkItemFactory"
	gtk_file: "gtkitemfactory.h"
	status: "See notice at end of class"
	signals: ""
	events: ""

class
	C_GTK_ITEM_FACTORY

feature -- External C functions

	gtk_item_factory_get_type: INTEGER is 
			-- Parsed as:
			-- GtkType gtk_item_factory_get_type (
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- GtkType		gtk_item_factory_get_type	    (void);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_new (a_container_type: INTEGER; a_path: POINTER; a_accel_group: POINTER): POINTER is 
			-- Parsed as:
			-- GtkItemFactory* gtk_item_factory_new (
			--     GtkType a_container_type,
			--     gchar *a_path,
			--     GtkAccelGroup *a_accel_group
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- GtkItemFactory*	gtk_item_factory_new	   (GtkType		 container_type,
			-- 					    const gchar		*path,
			-- 					    GtkAccelGroup       *accel_group);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_construct (a_ifactory: POINTER; a_container_type: INTEGER; a_path: POINTER; a_accel_group: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_construct (
			--     GtkItemFactory *a_ifactory,
			--     GtkType a_container_type,
			--     gchar *a_path,
			--     GtkAccelGroup *a_accel_group
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void		gtk_item_factory_construct (GtkItemFactory	*ifactory,
			-- 					    GtkType		 container_type,
			-- 					    const gchar		*path,
			-- 					    GtkAccelGroup       *accel_group);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_parse_rc (a_file_name: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_parse_rc (
			--     gchar *a_file_name
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void		gtk_item_factory_parse_rc	    (const gchar    *file_name);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_parse_rc_string (a_rc_string: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_parse_rc_string (
			--     gchar *a_rc_string
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void		gtk_item_factory_parse_rc_string    (const gchar    *rc_string);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_parse_rc_scanner (a_scanner: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_parse_rc_scanner (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void		gtk_item_factory_parse_rc_scanner   (GScanner	    *scanner);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_add_foreign (a_accel_widget: POINTER; a_full_path: POINTER; a_accel_group: POINTER; a_keyval: INTEGER; a_modifiers: INTEGER) is 
			-- Parsed as:
			-- void gtk_item_factory_add_foreign (
			--     GtkWidget *a_accel_widget,
			--     gchar *a_full_path,
			--     GtkAccelGroup *a_accel_group,
			--     guint a_keyval,
			--     GdkModifierType a_modifiers
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void		gtk_item_factory_add_foreign        (GtkWidget	    *accel_widget,
			-- 						     const gchar    *full_path,
			-- 						     GtkAccelGroup  *accel_group,
			-- 						     guint	     keyval,
			-- 						     GdkModifierType modifiers);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_from_widget (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- GtkItemFactory* gtk_item_factory_from_widget (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- GtkItemFactory*	gtk_item_factory_from_widget	    (GtkWidget	      *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_path_from_widget (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* gtk_item_factory_path_from_widget (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- gchar*		gtk_item_factory_path_from_widget   (GtkWidget	      *widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_get_item (a_ifactory: POINTER; a_path: POINTER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_item_factory_get_item (
			--     GtkItemFactory *a_ifactory,
			--     gchar *a_path
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- GtkWidget*	gtk_item_factory_get_item	      (GtkItemFactory *ifactory,
			-- 						       const gchar    *path);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_get_widget (a_ifactory: POINTER; a_path: POINTER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_item_factory_get_widget (
			--     GtkItemFactory *a_ifactory,
			--     gchar *a_path
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- GtkWidget*	gtk_item_factory_get_widget	      (GtkItemFactory *ifactory,
			-- 						       const gchar    *path);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_get_widget_by_action (a_ifactory: POINTER; a_action: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_item_factory_get_widget_by_action (
			--     GtkItemFactory *a_ifactory,
			--     guint a_action
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- GtkWidget*	gtk_item_factory_get_widget_by_action (GtkItemFactory *ifactory,
			-- 						       guint	       action);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_get_item_by_action (a_ifactory: POINTER; a_action: INTEGER): POINTER is 
			-- Parsed as:
			-- GtkWidget* gtk_item_factory_get_item_by_action (
			--     GtkItemFactory *a_ifactory,
			--     guint a_action
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- GtkWidget*	gtk_item_factory_get_item_by_action   (GtkItemFactory *ifactory,
			-- 						       guint	       action);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_dump_items (a_path_pspec: POINTER; a_modified_only: BOOLEAN; a_print_func: POINTER; a_func_data: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_dump_items (
			--     GtkPatternSpec *a_path_pspec,
			--     gboolean a_modified_only,
			--     GtkPrintFunc a_print_func,
			--     gpointer a_func_data
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_dump_items	(GtkPatternSpec		*path_pspec,
			-- 					 gboolean		 modified_only,
			-- 					 GtkPrintFunc		 print_func,
			-- 					 gpointer		 func_data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_dump_rc (a_file_name: POINTER; a_path_pspec: POINTER; a_modified_only: BOOLEAN) is 
			-- Parsed as:
			-- void gtk_item_factory_dump_rc (
			--     gchar *a_file_name,
			--     GtkPatternSpec *a_path_pspec,
			--     gboolean a_modified_only
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_dump_rc	(const gchar		*file_name,
			-- 					 GtkPatternSpec		*path_pspec,
			-- 					 gboolean		 modified_only);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_print_func (a_FILE_pointer: POINTER; a_string: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_print_func (
			--     gpointer a_FILE_pointer,
			--     gchar *a_string
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_print_func	(gpointer		 FILE_pointer,
			-- 					 gchar			*string);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_create_item (a_ifactory: POINTER; a_entry: POINTER; a_callback_data: POINTER; a_callback_type: INTEGER) is 
			-- Parsed as:
			-- void gtk_item_factory_create_item (
			--     GtkItemFactory *a_ifactory,
			--     GtkItemFactoryEntry *a_entry,
			--     gpointer a_callback_data,
			--     guint a_callback_type
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_create_item	(GtkItemFactory		*ifactory,
			-- 					 GtkItemFactoryEntry	*entry,
			-- 					 gpointer		 callback_data,
			-- 					 guint			 callback_type);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_create_items (a_ifactory: POINTER; a_n_entries: INTEGER; a_entries: POINTER; a_callback_data: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_create_items (
			--     GtkItemFactory *a_ifactory,
			--     guint a_n_entries,
			--     GtkItemFactoryEntry *a_entries,
			--     gpointer a_callback_data
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_create_items	(GtkItemFactory		*ifactory,
			-- 					 guint			 n_entries,
			-- 					 GtkItemFactoryEntry	*entries,
			-- 					 gpointer		 callback_data);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_delete_item (a_ifactory: POINTER; a_path: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_delete_item (
			--     GtkItemFactory *a_ifactory,
			--     gchar *a_path
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_delete_item	(GtkItemFactory		*ifactory,
			-- 					 const gchar		*path);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_delete_entry (a_ifactory: POINTER; a_entry: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_delete_entry (
			--     GtkItemFactory *a_ifactory,
			--     GtkItemFactoryEntry *a_entry
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_delete_entry	(GtkItemFactory		*ifactory,
			-- 					 GtkItemFactoryEntry	*entry);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_delete_entries (a_ifactory: POINTER; a_n_entries: INTEGER; a_entries: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_delete_entries (
			--     GtkItemFactory *a_ifactory,
			--     guint a_n_entries,
			--     GtkItemFactoryEntry *a_entries
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_delete_entries	(GtkItemFactory		*ifactory,
			-- 					 guint			 n_entries,
			-- 					 GtkItemFactoryEntry	*entries);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_popup (a_ifactory: POINTER; a_x: INTEGER; a_y: INTEGER; a_mouse_button: INTEGER; a_time: INTEGER) is 
			-- Parsed as:
			-- void gtk_item_factory_popup (
			--     GtkItemFactory *a_ifactory,
			--     guint a_x,
			--     guint a_y,
			--     guint a_mouse_button,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_popup		(GtkItemFactory		*ifactory,
			-- 					 guint			 x,
			-- 					 guint			 y,
			-- 					 guint			 mouse_button,
			-- 					 guint32		 time);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_popup_with_data (a_ifactory: POINTER; a_popup_data: POINTER; a_destroy: POINTER; a_x: INTEGER; a_y: INTEGER; a_mouse_button: INTEGER; a_time: INTEGER) is 
			-- Parsed as:
			-- void gtk_item_factory_popup_with_data (
			--     GtkItemFactory *a_ifactory,
			--     gpointer a_popup_data,
			--     GtkDestroyNotify a_destroy,
			--     guint a_x,
			--     guint a_y,
			--     guint a_mouse_button,
			--     guint32 a_time
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_popup_with_data(GtkItemFactory		*ifactory,
			-- 					 gpointer		 popup_data,
			-- 					 GtkDestroyNotify	 destroy,
			-- 					 guint			 x,
			-- 					 guint			 y,
			-- 					 guint			 mouse_button,
			-- 					 guint32		 time);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_popup_data (a_ifactory: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer gtk_item_factory_popup_data (
			--     GtkItemFactory *a_ifactory
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- gpointer gtk_item_factory_popup_data	(GtkItemFactory		*ifactory);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_popup_data_from_widget (a_widget: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer gtk_item_factory_popup_data_from_widget (
			--     GtkWidget *a_widget
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- gpointer gtk_item_factory_popup_data_from_widget (GtkWidget	*widget);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_set_translate_func (a_ifactory: POINTER; a_func: POINTER; a_data: POINTER; a_notify: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_set_translate_func (
			--     GtkItemFactory *a_ifactory,
			--     GtkTranslateFunc a_func,
			--     gpointer a_data,
			--     GtkDestroyNotify a_notify
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void   gtk_item_factory_set_translate_func (GtkItemFactory      *ifactory,
			-- 					    GtkTranslateFunc     func,
			-- 					    gpointer             data,
			-- 					    GtkDestroyNotify     notify);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_from_path (a_path: POINTER): POINTER is 
			-- Parsed as:
			-- GtkItemFactory* gtk_item_factory_from_path (
			--     gchar *a_path
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- GtkItemFactory*	gtk_item_factory_from_path   (const gchar       *path);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_create_menu_entries (a_n_entries: INTEGER; a_entries: POINTER) is 
			-- Parsed as:
			-- void gtk_item_factory_create_menu_entries (
			--     guint a_n_entries,
			--     GtkMenuEntry *a_entries
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_create_menu_entries (guint		 n_entries,
			-- 					      GtkMenuEntry      *entries);
		external
			" C | <gtk/gtk.h>"
		end

	gtk_item_factory_create_items_ac (a_ifactory: POINTER; a_n_entries: INTEGER; a_entries: POINTER; a_callback_data: POINTER; a_callback_type: INTEGER) is 
			-- Parsed as:
			-- void gtk_item_factory_create_items_ac (
			--     GtkItemFactory *a_ifactory,
			--     guint a_n_entries,
			--     GtkItemFactoryEntry *a_entries,
			--     gpointer a_callback_data,
			--     guint a_callback_type
			-- );
			--
			-- Original C code from gtkitemfactory.h:
			-- void	gtk_item_factory_create_items_ac (GtkItemFactory	*ifactory,
			-- 					  guint			 n_entries,
			-- 					  GtkItemFactoryEntry	*entries,
			-- 					  gpointer		 callback_data,
			-- 					  guint			 callback_type);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GTK_ITEM_FACTORY

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)