indexing
	description: "List of C structs"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/19 21:21:30 $"
	revision: "$Revision: 1.2 $"

class
	C_STRUCTS

inherit
	LINKED_LIST [C_STRUCT]

create
	make

feature

	struct_typedefs: LINKED_LIST [C_TYPEDEF]

	set_struct_typedefs (some_struct_typedefs: LINKED_LIST [C_TYPEDEF]) is
		do
			struct_typedefs := some_struct_typedefs
		end

	link_typedef_names is
			-- Match typedef names to struct names.
		require
			struct_typedefs_not_void: struct_typedefs /= Void
		do
			from struct_typedefs.start
			until struct_typedefs.after
			loop
				from start
				until after
				loop
					if item.name /= Void and then item.name.is_equal (struct_typedefs.item.base) then
						item.set_typedef_name (struct_typedefs.item.name)
					end
					forth
				end
				struct_typedefs.forth
			end
		end

        resolve_member_typedefs (tds: C_TYPEDEFS) is
                do
                        from start until after loop
                                from item.members.start
                                until item.members.after
                                loop
                                        item.members.item.set_typedef (tds.get_typedef (item.members.item.type))
                                        item.members.forth
                                end
                                forth
                        end
                end

feature -- Output

        dump (dir: DIRECTORY; include_directive: STRING; status: STRING; ticker: TICKER) is
                        -- Dump all struct texts to files in `dir'.
                do
                        from start until after loop
                                item.dump (dir, include_directive, status)
                                ticker.tick
                                forth
                        end
                end

end -- class C_STRUCTS


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
