%{

indexing
	description: "Parse C header file for structs"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/19 21:21:30 $"
	revision: "$Revision: 1.2 $"

class C_STRUCT_PARSER

inherit

	YY_PARSER_SKELETON [C_STRUCT_PARSER_UNION]
		rename
			make as yy_parser_skeleton_make
		redefine
			report_error
		end

	C_STRUCT_SCANNER
		rename
			make_with_file as c_struct_scanner_make_with_file
		end

creation

	make_with_file

%}

%token TOK_FILE
%token TOK_STRUCT
%token TOK_STRUCT_TD
%token TOK_ID
%token TOK_INDIR
%token TOK_LB
%token TOK_RB
%token TOK_SC

%%

input:     -- empty
           | input TOK_FILE defs {
                 from $3.sts.start until $3.sts.after loop
			 $3.sts.item.set_h_file_name ($2.s)
			 $3.sts.forth
                 end
           }
           ;

defs:      { create $$.csts (!LINKED_LIST [C_STRUCT]!.make) } -- empty
           | defs struct {
                 ticker.tick
                 $1.sts.extend ($2.st)
                 c_structs.extend ($2.st)
                 $$ := $1
           } 
           | defs struct_td {
                 ticker.tick
                 c_typedefs.extend ($2.td)
                 $$ := $1
           } 
           ;

struct_td:   TOK_STRUCT_TD member {
                 create $$.ctd (!C_TYPEDEF!.make ($2.a.name, $2.a.indir, $2.a.type))
           };

struct:      TOK_STRUCT struct_id TOK_LB members TOK_RB struct_id TOK_SC {
                 create $$.cst (!C_STRUCT!.make ($2.s, $4.a_s, $6.s))
           };

struct_id: { create $$.cs (Void) } -- empty
           | TOK_ID { $$ := $1}
           ;

members:     member {
                 create $$.cas (!C_ARGUMENTS!.make)
                 $$.a_s.extend ($1.a)
           }
           | members member {
                 $1.a_s.extend ($2.a)
                 $$ := $1
           };

member:      typename TOK_ID TOK_SC {
                 create $$.ca (!C_ARGUMENT!.make_with_type ($2.s, $1.s))
           }
           | typename indir TOK_ID func_ptr_junk TOK_SC {
                 create $$.ca (!C_ARGUMENT!.make_with_type_and_indir ($3.s, $1.s, $2.s.count))
           };

indir:       TOK_INDIR { $$ := $1 }
           | indir TOK_INDIR {
                 create $$.cs ($1.s + $2.s)
           };

func_ptr_junk: -- empty
           | func_ptr_junk TOK_ID    
           | func_ptr_junk TOK_INDIR
           ;

typename:    TOK_ID { $$ := $1 }
           | typename TOK_ID {
                 create $$.cs ($1.s + " " + $2.s)
           };

%%

feature -- Initialization

	make_with_file (file: IO_MEDIUM; t: TICKER)  is
			-- Initialize scanner with file
			-- Initialize parser
			-- Initialize `parsed_prototypes'
		require
			file_open_for_read: file.is_open_read
		do
			c_struct_scanner_make_with_file (file)
			yy_parser_skeleton_make
			ticker := t
		end

feature -- Implementation

	report_error (a_message: STRING) is
		do
			io.put_string("C_STRUCT_PARSER ")
			io.put_string(a_message)
			io.put_new_line
		end

	u: C_STRUCT_PARSER_UNION

	c_structs: LINKED_LIST [C_STRUCT]

	c_typedefs: LINKED_LIST [C_TYPEDEF]
	
	ticker: TICKER

end


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
