indexing
	description: "List of C enums"
	status: "see notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:41 $"
	revision: "$Revision: 1.1.1.1 $"

class
	C_ENUMS

inherit
	LINKED_LIST [C_ENUM]

creation
	make

feature -- Conversion to eiffel text

	eiffel_text (class_name: STRING): STRING is
			-- Eiffel text with constant eiffel INTEGERs for enums
		require
			class_name_valid: class_name /= Void
		local
			name: STRING
			r: FMT_STRING
			c: CHARACTER
		do
			create r.make
			Result := r
			r.append ("indexing%N")
			r.append ("%Tdescription: %"Constants derived from GTK enums.%"%N")
			r.append ("%Tstatus: %"See notice at end of class%"%N%N")
			r.append ("class%N%T^%N%Nfeature -- C enums%N%N")
			r.inject (class_name)
			from start
			until after
			loop
				name := clone (item.name)
				c := name.item (1)
				name.tail (name.count - 1)
				name.to_lower
				name.prepend_character (c)
				r.append ("%T^: INTEGER is ^%N%N")
				r.inject (name)
				r.inject (item.value)
				forth
			end
			r.append ("end -- class ^%N")
			r.inject (class_name)
		end
feature -- Output

	dump (class_name: STRING; dir: DIRECTORY; status: STRING) is
			-- Dump the Eiffel text of `Current' to a file in `dir'
		local
			f: RAW_FILE
			fn: STRING
		do
			fn := clone (class_name)
			fn.append (".e")
			fn.prepend_character (operating_environment.directory_separator)
			fn.prepend (dir.name)
			fn.to_lower
			create f.make (fn)

			f.open_write
			f.put_string (eiffel_text (class_name))
			f.put_string (status)
			f.close
		end

end -- class C_ENUMS


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
