-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description "Template for all writers"
	author "Daniel Elphick <de397@ecs.soton.ac.uk>"

deferred class WRITER

feature

	widget_tree: TAG_TREE
	indentation: INTEGER
	src_dir: STRING

	indent is
		do
			indentation := indentation + 1
		ensure
			increased: indentation = old indentation + 1
		end
	
	outdent is
		require
			indented: indentation > 0
		do
			indentation := indentation - 1
		ensure
			decrease: indentation = old indentation - 1
		end

	write_lines(lines: ARRAY[STRING]) is
		require
			valid_lines: lines /= Void
		local
			i: INTEGER
		do
			from
				i := 0
			variant
				lines.count - i
			until
				i >= lines.count
			loop
				write_line(lines @ i)
				i := i + 1
			end
		end
				
	write_line(line: STRING) is
		require
			line_is_string: line /= Void
		local
			i: INTEGER
		do
			from
				i := 0
			variant
				indentation - i
			until
				i >= indentation
			loop
				file.put_character('%T')
				i := i + 1
			end
			file.put_string(line)
			file.put_new_line
		end
			
	blank_line is
		do
			file.put_new_line
		end
end
