-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description:	"This class writes the CUSTOMISATION class"
	author:		"Oliver Elphick <olly@lfix.co.uk>"
	date:          "October 31 1999"
	cvs:           "$Id: custom_class_writer.e,v 1.3 1999/11/11 22:11:57 elphick Exp $"

class CUSTOM_CLASS_WRITER

inherit

   PRESERVED_CLASS_WRITER
      rename
			widget_tree as interface
      redefine
			write_inherit, write_creation
      end

creation
	make

feature
	
	name: STRING is "GTK-Interface"
	root_features: LINKED_LIST[CAN_BE_CREATED]

	inherit_from: STRING is "GTK_APPLICATION%N%N%TTOP_LEVEL_WINDOWS%N%N%TCUSTOMISATION"

	make(src: STRING) is
			-- Writes the source file
		require
			valid_src: src /= Void and then not src.empty
		do
			src_dir := src
			classname := "CUSTOMISATION"
			filename := clone(classname)
			filename.to_lower
			filename.prepend(src_dir)
			filename.append(".e")
		end

	write_features is
		do
		   write_line ("begin is")
		   indent
		   write_line("do")
		   write_line("end")
		   outdent
		end

	write_make_body is
		do
		end

	write_inherit is
		do
		end

	write_creation is
		do
		end

end -- CUSTOM_CLASS_WRITER
