
open Names;;

open Std;;

open More_util;;

open Generic;;

open Ast;;

open Term;;

open Pp;;

open Termenv;;

open Libobject;;

open Library;;

open Vernacinterp;;

open Trad;;

open Proof_trees;;

open Termast;;

open Tacmach;;

open Pfedit;;

open Parsing;;

open Evd;;

open Xlate;;

open CoqAst;;

open Vtp;;

open Ascent;;

open Environ;;

(*the centaur datatype of a state-message:
  STATE ::= state of PATH * RULE_LIST;;
  RULE_LIST ::= rule_list of list[RULE]
  RULE ::= rule of PATH * PREMISES_LIST * FORMULA;;
  PREMISES_LIST ::= premises_list of list[PREMISE];;
  PREMISE ::= premise of IDENT * FORMULA;;
  The coq datatypes corresponding are:
  PATH == (path==int list) for path of node
  RULE == path * GOAL;;
  RULE_LIST == (path * GOAL) list;;
  PREMISE == premise of IDENT * FORMULA;;*)
(*grace a chet ... this live typically in V5.10/MISC *)
let rel_reference gt k oper = 
 if is_existential_oper oper then ope("XTRA", [str "ISEVAR"])
 else begin
  let id = id_of_global oper in
  let oper', _ = global_operator (Nametab.sp_of_id k id) id in
  if oper = oper' then nvar (string_of_id id)
  else failwith "xlate"
end;;

let relativize relfun =
 let rec relrec =
  function
     | Nvar (_, id) -> nvar id
     | Slam (l, na, ast) -> Slam (l, na, relrec ast)
     | Node (loc, nna, l) as ast -> begin
       try relfun ast
       with
       | Failure _ -> Node (loc, nna, List.map relrec l)
     end
     | a -> a in
 relrec;;

let dbize_sp =
 function
    | Path (loc, sl, s) -> begin
      try section_path sl s
      with
      | Invalid_argument _ | Failure _ ->
      anomaly_loc
       (loc, "Translate.dbize_sp (taken from Astterm)",
       [< 'sTR "malformed section-path" >])
    end
    | ast ->
     anomaly_loc
      (Ast.loc ast, "Translate.dbize_sp (taken from Astterm)",
      [< 'sTR "not a section-path" >]);;

let relativize_cci gt = relativize (function
    | Node (_, "CONST", (p :: _)) as gt ->
     rel_reference gt CCI (Const (dbize_sp p))
    | Node (_, "MUTIND", (p :: ((Num (_, tyi)) :: _))) as gt ->
     rel_reference gt CCI (MutInd (dbize_sp p, tyi))
    | Node (_, "MUTCONSTRUCT", (p :: ((Num (_, tyi)) :: ((Num (_, i)) :: _)))) as gt ->
     rel_reference gt CCI (MutConstruct (
      (dbize_sp p, tyi), i))
    | _ -> failwith "caught") gt;;

let coercion_description_holder = ref (function _ -> None : t -> int option);;

let coercion_description t = !coercion_description_holder t;;

let set_coercion_description f =
 coercion_description_holder:=f; ();;

let rec nth_tl l n = if n = 0 then l
 else (match l with
 | a :: b -> nth_tl b (n - 1)
 | [] -> failwith "list too short for nth_tl");;

let rec discard_coercions =
 function
    | Slam (l, na, ast) -> Slam (l, na, discard_coercions ast)
    | Node (l, ("APPLIST" as nna), (f :: args as all_sons)) ->
     (match coercion_description f with
     | Some n ->
      let new_args =
       try nth_tl args n
       with
       | Failure "list too short for nth_tl" -> [] in
      (match new_args with
       | a :: (b :: c) -> Node (l, nna, List.map discard_coercions new_args)
       | a :: [] -> discard_coercions a
       | [] -> Node (l, nna, List.map discard_coercions all_sons))
     | None -> Node (l, nna, List.map discard_coercions all_sons))
    | Node (l, nna, all_sons) ->
     Node (l, nna, List.map discard_coercions all_sons)
    | it -> it;;

(*translates a formula into a centaur-tree --> FORMULA *)
let translate_constr assumptions c =
 let com = bdize_no_casts true assumptions c in
 let rcom = relativize_cci (discard_coercions com) in
 xlate_formula rcom;;

(*translates a signature into a centaur-tree --> PREMISES_LIST *)
let translate_sign (l1, l2 as sign) =
 let l = List.combine l1 l2 in
 CT_premises_list (List.map (function id, c ->
  let xcom = translate_constr (gLOB sign) (body_of_type c) in
  CT_premise (CT_ident (string_of_id id), xcom)) l);;

(*translates an int list into a centaur-tree --> SIGNED_INT_LIST *)
let translate_path l =
 CT_signed_int_list
 (List.map (function n -> CT_coerce_INT_to_SIGNED_INT (CT_int n)) (List.rev l));;

(*translates a path and a goal into a centaur-tree --> RULE *)
let translate_goal path g =
 CT_rule
 (translate_path path, translate_sign g.hyps,
 translate_constr (gLOB g.hyps) g.concl);;

(*translates a new state into a centaur-tree --> STATE *)
let translate_state path sgl =
 CT_state (translate_path path, CT_path_list (Std.map_i (function i ->
                                 (function gl -> translate_path (i::path))) 1
                                 sgl));;

let translate_node_state path pf = CT_rule_list [translate_goal path pf.goal];;

let rec goals_and_paths path p =
 match p.ref with
 | None -> [p.goal, path]
 | Some (r, pfl) ->
  let gll = Std.map_i (fun r pf -> goals_and_paths (r::path) pf) 1 pfl in
  List.flatten gll;;

let translate_all_goals path pf =
 let goal_and_path_list = goals_and_paths path pf in
 let tr_goal (a, b) = translate_goal b a in
 CT_rule_list (List.map tr_goal goal_and_path_list);;
