(in-package :ext)
(export '*batch-mode*)
(in-package :user)

(pushnew :direct-syscall *features*)

;(pushnew :thread *features*)

;(pushnew :cross-compiler *features*)
(setf *features* (remove :cross-compiler *features*))
;(pushnew :bootstrap *features*)
(setf *features* (remove :bootstrap *features*))

(pushnew :direct-syscall *features*)

; glibc2 support:
(pushnew :glibc2 *features*)
;(setf *features* (remove :glibc2 *features*))

(pushnew :cmu18 *features*)
(pushnew :cmu17 *features*)
(pushnew :signed-array *features*)
(pushnew :complex-float *features*)
(pushnew :hash-new *features*)

; Multiprocessing:
(pushnew :mp *features*)
;(setf *features* (remove :mp  *features*))

;; compiler now depends on this :-(
;(pushnew :i486 *features*)
(setf *features* (remove :i486 *features*))
;(pushnew :pentium *features*)
(setf *features* (remove :pentium *features*))

; bytecompile some stuff?
(setf *features* (remove :small  *features*))
;(pushnew :small *features*)

;(pushnew :new-random *features*)
(setf *features* (remove :new-random *features*))
;(pushnew :random-df *features*)
(setf *features* (remove :new-df *features*))
;(pushnew :random-lfsr113 *features*)
(setf *features* (remove :new-lfsr113 *features*))
(pushnew :random-mt19937 *features*)
;(setf *features* (remove :new-mt19937 *features*))
;(pushnew :random-acarry-skip *features*)
(setf *features* (remove :new-acarry-skip *features*))
;(pushnew :random-acarrypc  *features*)
(setf *features* (remove :new-acarrypc *features*))

(pushnew :propagate-float-type *features*)
(pushnew :propagate-fun-type *features*)
(setf *features* (remove :propagate-trig-fun *features*))
(pushnew :constrain-float-type	*features*)
(pushnew :signed-array *features*)

(pushnew :gencgc *features*)

;(pushnew :cgc *features*)
(setf *features* (remove :cgc *features*))
; Conservative GC

(pushnew :linux *features*)
(setf *features* (remove :x86-lra *features*))

(setf *features* (remove :bsd *features*))
(setf *features* (remove :freebsd *features*))

(setf (ext:search-list "target:")
	   '(	"./x86/"      ; object dir
;	        "./p86/"
        	"./src/"))   ; source dir

(setf (ext:search-list "library:") '("/usr/lib/cmucl/"))

;;; Tailor this for what you want. This is the basics.
;;; The worldload process will use these features or lack thereof.
;;(pushnew :no-compiler *features*)
;(pushnew :no-pcl *features*)
(setf *features* (remove :no-pcl *features*))

;(setf *features* (remove :no-clx *features*))
;(setf *features* (remove :no-hemlock  *features*))
(pushnew :no-clx *features*)
(pushnew :no-clm *features*)
(pushnew :no-hemlock *features*)
; it's best to compile this to packages...

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(setf lisp::*genesis-c-header-name* "target:lisp/internals.h")
(setf lisp::*genesis-symbol-table* "target:lisp/lisp.nm")
(setf lisp::*genesis-map-name* "target:lisp/lisp.map")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
