(declaim (optimize (speed 3) (safety 0)))

;;; This example shows a case where a double-float to pointer coercion
;;; occurs in a rather poor location. Not a bug but perhaps a new
;;; feature is needed to bias the representation selection.
(defun test(a n)
  (declare (type (simple-array double-float (*)) a)
	   (fixnum n))
  (let ((sum 2d0))
    (declare (type double-float sum))
    (dotimes (i n)
      (incf sum (* (aref a i)(aref a i)))) ; << double-float to pointer here
    sum))
