/*
 * Time-stamp: <98/11/05 15:22:17 panic>
 * Author:	The C-Mix Project <cmix@diku.dk>
 *              Peter Holst Andersen <txix@diku.dk>
 *              Arne John Glenstrup <panic@diku.dk>
 * Contents:	Scenes
 */

#include "ray.h"
#include "create.h"
#include "math.h"
#include <stdio.h>

extern int last_object;

int lastscene = 15;

void scene1()
{
  surfaceT s1;
  s1 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 5);
  create_sphere(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, s1);
  create_disc  (0.0, 0.0, -2.5, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.5, s1);
  create_square(0.0, 0.0, 2.5, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.5, s1);
  create_light(1.0, 1.0, 1.0, 8.0, -8.0, 8.0);
  return;
}

void scene2()
{
  surfaceT s1, s2, s3, s4, s5;
  s1 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 5);
  s2 = create_simple_surface(0.0, 0.0, 0.0, 0.0, 0.0, 1);
  s3 = create_special_color_surface
    (0.02, 0.015, 0.0066, 0.8, 0.6, 0.264, 1.0, 0.0, 1.0, 5);
  s4 = create_color_surface(0.2, 0.2, 0.0, 0.0, 1.0, 1000, 1.0, 0.2, 0.0);
  s5 = create_checked_surface(s1, s4, PI * 4.0 / 24.0);
  create_sphere(0.0, 0.0, 0.0, 0.3, -1.0, 0.3, 2.0, s5);
  create_disc  (0.0, 0.0, -2.5, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 2.0, s1);
  create_square(0.0, 0.0, 2.5, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.5, s3);
  create_light(1.0, 1.0, 1.0, 8.0, -8.0, 8.0);
  return;
}

void scene3()
{
  surfaceT s1, s2, s3;
  s1 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 5);
  s2 = create_simple_surface(0.0, 0.0, 0.0, 0.0, 0.0, 1);
  s3 = create_checked_surface(0, 1, 0.25);
  create_square(0.0, 0.0, 0.0, -0.3, 1.0, 0.5, 1.0, 0.3, 0.0, 1.5, s3);
  create_disc  (0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.3, 0.0, 0.5, 1.6, s3);
  create_light(1.0, 1.0, 1.0, 8.0, -8.0, 8.0);
  return;
}

void scene4()
{
  surfaceT s1, s2, s3, s4, s5;
  s1 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 5);
  s2 = create_simple_surface(0.0, 0.0, 0.0, 0.0, 0.0, 1);
  s3 = create_checked_surface(s1, s2, 1.5);
  s4 = create_simple_surface(0.1, 0.1, 0.7, 0.0, 0.0, 15);
  s5 = create_simple_surface(0.1, 0.1, 0.1, 0.8, 1.3, 15);
  create_sphere(0.0, 4.0, 5.0, 0.0, 0.0, 1.0, 2.5, s4);
  create_sphere(0.7, -1.0, 4.0, 0.0, 0.0, 1.0, 1.6, s5);
  create_square(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 20.0, s3);
  create_light(1.0, 1.0, 1.0, 8.0, -8.0, 24.0);
  defaultview.pos.x = 0.0;
  defaultview.pos.y = -8.0;
  defaultview.pos.z = 6.0;
  defaultview.lookp.x = 0.0;
  defaultview.lookp.y = 0.0;
  defaultview.lookp.z = 3.0;
  return;
}

void scene5()
{
  double sqrt3, x, y, z;
  surfaceT s1, s2, s3, s4;

  sqrt3 = sqrt(3.0);

  s1 = create_simple_surface(0.01, 0.2, 0.1, 0.9, 1.3, 6);
  s2 = create_simple_surface(0.0, 0.0, 0.0, 0.0, 0.0, 1);
  s3 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 6);
  s4 = create_checked_surface(s3, s2, 0.8);

  create_sphere(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-2.0, 2.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 0.0, 2.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 2.0, 2.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-3.0, 3.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, 3.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, 3.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 3.0, 3.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-4.0, 4.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-2.0, 4.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 0.0, 4.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 2.0, 4.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 4.0, 4.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  z = sqrt(8.0/3.0);
  y = 2.0 / sqrt3;
  create_sphere( 0.0, y, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-2.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 0.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 2.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-3.0, y+3.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, y+3.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, y+3.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 3.0, y+3.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  z = 2.0 * sqrt(8.0/3.0);
  y = 4.0 / sqrt3;
  create_sphere( 0.0, y, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-2.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 0.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 2.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  z = 3.0 * sqrt(8.0/3.0);
  y = 6.0 / sqrt3;
  create_sphere( 0.0, y, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
    		
  create_sphere( 0.0, 8.0 / sqrt3, 4.0 * sqrt(8.0/3.0), 0.0, 0.0, 1.0, 1.0, s1);

  create_square(0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 40.0, s4);

  create_light(1.0, 1.0, 1.0, 5.0, -20.0, 20.0);

  defaultview.lookp.x = 0.0;
  defaultview.lookp.y = 2.0 * sqrt3;
  defaultview.lookp.z = 2.75;

  defaultview.pos.x = 3.0;
  defaultview.pos.y = -10.0;
  defaultview.pos.z = 6.0;

  return;
}

void scene6()
{
  surfaceT s1;
  s1 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 5);
  create_sphere(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.2, s1);
  create_sphere(0.0, -2.0, -0.5, 0.0, 0.0, 1.0, 0.5, s1);
  create_sphere(3.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.2, s1);
  create_sphere(-3.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.2, s1);
  create_sphere(0.0, 0.0, -8.0, 0.0, 0.0, 1.0, 5.0, s1);
  create_light(0.0, 0.4, 0.4, -40.0, -20.0, 20.0);
  create_light(0.6, 0.0, 0.0, -20.0, -20.0, 20.0);
  create_light(0.0, 0.6, 0.0, 0.0, -20.0, 20.0);
  create_light(0.0, 0.0, 0.6, 20.0, -20.0, 20.0);
  create_light(0.4, 0.4, 0.0, 40.0, -20.0, 20.0);
  return;
}

void scene7()
{
  surfaceT s1, s2, s3, s4;
  s1 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 5);
  s2 = create_simple_surface(0.0, 0.0, 0.0, 0.0, 0.0, 6);
  s3 = create_checked_surface(s1, s2, 0.2);
  s4 = create_checked_surface(s1, s3, 0.8);
  create_disc(0.0, 0.0, -3.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 2.0, s4);
  create_disc(0.0, 0.0, -2.0, 0.0, 0.2, 0.7, 0.9, 0.1, 0.0, 2.0, s4);
  create_disc(0.0, 0.0, -1.0, 0.0, 0.2, 0.6, 0.8, 0.2, 0.0, 2.0, s4);
  create_disc(0.0, 0.0,  1.0, 0.0, 0.2, 0.5, 0.7, 0.3, 0.0, 2.0, s4);
  create_disc(0.0, 0.0,  3.0, 0.0, 0.1, 0.2, 0.6, 0.4, 0.0, 2.0, s4);
  create_light(0.0, 0.4, 0.4, -40.0, -20.0, 20.0);
  create_light(0.6, 0.0, 0.0, -20.0, -20.0, 20.0);
  create_light(0.0, 0.6, 0.0, 0.0, -20.0, 20.0);
  create_light(0.0, 0.0, 0.6, 20.0, -20.0, 20.0);
  create_light(0.4, 0.4, 0.0, 40.0, -20.0, 20.0);
  return;
}

void scene8()
{
  surfaceT s1;
  s1 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 5);
  create_square(0.0,0.0,-4.0, 0.0,0.0,1.0, 1.0,0.0,0.0, 2.0, s1);
  create_square(0.0,0.0,-2.0, 0.0,0.2,0.8, 1.0,0.0,0.0, 2.0, s1);
  create_square(0.0,0.0, 0.0, 0.0,0.4,0.6, 1.0,0.0,0.0, 2.0, s1);
  create_square(0.0,0.0, 2.0, 0.0,0.6,0.4, 1.0,0.0,0.0, 2.0, s1);
  create_square(0.0,0.0, 4.0, 0.0,0.8,0.2, 1.0,0.0,0.0, 2.0, s1);
  create_light(0.0, 0.4, 0.4, -40.0, -20.0, 20.0);
  create_light(0.6, 0.0, 0.0, -20.0, -20.0, 20.0);
  create_light(0.0, 0.6, 0.0, 0.0, -20.0, 20.0);
  create_light(0.0, 0.0, 0.6, 20.0, -20.0, 20.0);
  create_light(0.4, 0.4, 0.0, 40.0, -20.0, 20.0);
  return;
}

void scene9()
     /* Scene with 5 spheres and 1 light source */
{
  surfaceT s1;
  s1 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 5);
  create_sphere( 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.2, s1);
  create_sphere( 0.0,-2.0,-0.5, 0.0, 0.0, 1.0, 0.5, s1);
  create_sphere( 3.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.2, s1);
  create_sphere(-3.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.2, s1);
  create_sphere( 0.0, 0.0,-8.0, 0.0, 0.0, 1.0, 5.0, s1);
  create_light(1.0, 1.0, 1.0, -40.0, -20.0, 20.0);
  return;
}

void scene10()
     /* Scene with 5 discs and 1 lightsource */
{
  surfaceT s1;
  s1 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 5);
  create_disc(0.0, 0.0, -3.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 2.0, s1);
  create_disc(0.0, 0.0, -2.0, 0.0, 0.2, 0.7, 1.0, 0.0, 0.0, 2.0, s1);
  create_disc(0.0, 0.0, -1.0, 0.0, 0.2, 0.6, 1.0, 0.0, 0.0, 2.0, s1);
  create_disc(0.0, 0.0,  1.0, 0.0, 0.2, 0.5, 1.0, 0.0, 0.0, 2.0, s1);
  create_disc(0.0, 0.0,  3.0, 0.0, 0.1, 0.2, 1.0, 0.0, 0.0, 2.0, s1);
  create_light(1.0, 1.0, 1.0, -40.0, -20.0, 20.0);
  return;
}

void scene11()
     /* Scene with 5 squares and 1 lightsource */
{
  surfaceT s1;
  s1 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 5);
  create_square(0.0,0.0,-4.0, 0.0,0.0,1.0, 1.0,0.0,0.0, 2.0, s1);
  create_square(0.0,0.0,-2.0, 0.0,0.2,0.8, 1.0,0.0,0.0, 2.0, s1);
  create_square(0.0,0.0, 0.0, 0.0,0.4,0.6, 1.0,0.0,0.0, 2.0, s1);
  create_square(0.0,0.0, 2.0, 0.0,0.6,0.4, 1.0,0.0,0.0, 2.0, s1);
  create_square(0.0,0.0, 4.0, 0.0,0.8,0.2, 1.0,0.0,0.0, 2.0, s1);
  create_light(1.0, 1.0, 1.0, -40.0, -20.0, 20.0);
  return;
}

void scene12()
     /* An open box (5 squares) lighted by 5 lightsources */
{
  surfaceT s1, s2, s3, s4;
  s1 = create_simple_surface(0.1, 0.1, 0.5, 0.0, 0.0, 6);
  s2 = create_simple_surface(0.0, 0.0, 0.0, 0.0, 0.0, 1);
  s3 = create_simple_surface(0.1, 0.1, 0.5, 0.0, 0.0, 6);
  s4 = create_checked_surface(s3, s2, 0.5);
  create_square( 0.0, 0.0, 0.0, 0.0,-1.0,0.0, 1.0,0.0,0.0, 2.0, s4);
  create_square( 0.0,-2.0, 2.0, 0.0, 0.0,1.0, 1.0,0.0,0.0, 2.0, s1);
  create_square( 0.0,-2.0,-2.0, 0.0, 0.0,1.0, 1.0,0.0,0.0, 2.0, s1);
  create_square( 2.0,-2.0, 0.0, 1.0, 0.0,0.0, 0.0,1.0,0.0, 2.0, s1);
  create_square(-2.0,-2.0, 0.0, 1.0, 0.0,0.0, 0.0,1.0,0.0, 2.0, s1);
  create_light(1.0, 1.0, 1.0, 0.0, -20.0, 0.0);
  create_light(0.0, 0.4, 0.4, 0.0, -20.0, 20.0);
  create_light(0.6, 0.0, 0.0, 0.0, -20.0, -20.0);
  create_light(0.0, 0.6, 0.0, 20.0, -20.0, 0.0);
  create_light(0.0, 0.0, 0.6, -20.0, -20.0, 0.0);

  defaultview.pos.x = 6.0;
  defaultview.pos.y = -13.0;
  defaultview.pos.z = 6.0;
  return;
}

void scene13()
{
  surfaceT s1, s2;
  
  background.red = 0.078;
  background.green = 0.361;
  background.blue = 0.753;

  defaultview.lookp.x = defaultview.lookp.y = defaultview.lookp.z = 0.0;
  defaultview.pos.x = 2.1;
  defaultview.pos.y = 1.3;
  defaultview.pos.z = 1.7;
  defaultview.up.x = 0.0;
  defaultview.up.y = 0.0;
  defaultview.up.z = 1.0;
  defaultview.hfov = defaultview.vfov = 45.0;

  create_light(0.2, 0.2, 0.2,  4.0,  3.0, 2.0);
  create_light(0.2, 0.2, 0.2,  1.0, -4.0, 4.0);
  create_light(0.2, 0.2, 0.2, -3.0,  1.0, 5.0);

  s1 = create_special_color_surface
    (0.02, 0.015, 0.0066, 0.8, 0.6, 0.264, 1.0, 0.0, 1.0,5);
  s2 = create_special_color_surface
      (0.0, 0.0, 0.0, 0.5, 0.45, 0.35, 0.5, 0.0, 0.5, 22);

  create_square(0.0,0.0,-0.5, 0.0,0.0,1.0, 1.0,0.0,0.0, 12.0, s1);
  create_sphere(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.5, s2);
  create_sphere( 0.272166,  0.272166,    0.544331, 0.0, 0.0, 1.0, 0.166667, s2);
  create_sphere( 0.643951,  0.172546, 1.11022e-16, 0.0, 0.0, 1.0, 0.166667, s2);
  create_sphere( 0.172546,  0.643951, 1.11022e-16, 0.0, 0.0, 1.0, 0.166667, s2);
  create_sphere(-0.371785, 0.0996195,    0.544331, 0.0, 0.0, 1.0, 0.166667, s2);
  create_sphere(-0.471405,  0.471405, 1.11022e-16, 0.0, 0.0, 1.0, 0.166667, s2);
  create_sphere(-0.643951, -0.172546, 1.11022e-16, 0.0, 0.0, 1.0, 0.166667, s2);
  create_sphere(0.0996195, -0.371785,    0.544331, 0.0, 0.0, 1.0, 0.166667, s2);
  create_sphere(-0.172546, -0.643951, 1.11022e-16, 0.0, 0.0, 1.0, 0.166667, s2);
  create_sphere( 0.471405, -0.471405, 1.11022e-16, 0.0, 0.0, 1.0, 0.166667, s2);
  return;
}

void scene14()
{
  surfaceT s1, s2, s3, s4, s5;
  s1 = create_simple_surface(0.1, 0.1, 0.6, 0.0, 0.0, 1000);
  s2 = create_special_color_surface
    (0.1, 0.0, 0.0, 0.2, 0.0, 0.0, 0.1, 0.0, 0.0, 1000);
  s3 = create_checked_surface(s1, s2, 1.5);
  s4 = create_simple_surface(0.01, 0.1,  0.1, 0.9, 1.3, 500);
  s5 = create_special_color_surface
    (0.0, 0.2, 0.0, 0.0, 0.05, 0.0, 0.8, 0.0, 0.0, 500);

  create_square( 0.0,0.0,0.0, 0.0,1.0,0.0, 1.0,0.0,0.0, 20.0, s3);
  create_sphere(-3.0, 2.0, 10.0, 0.0, 0.0, 1.0, 1.2, s5);
  create_sphere( 0.0, 2.0, 10.0, 0.0, 0.0, 1.0, 1.2, s4);
  create_sphere( 3.0, 2.0, 10.0, 0.0, 0.0, 1.0, 1.2, s5);

  create_light(0.4, 0.4, 0.4,   0.0, 30.0, -10.0);
  create_light(0.4, 0.4, 0.4, -20.0, 30.0,  10.0);
  create_light(0.4, 0.4, 0.4, -14.0, 30.0,  -4.0);
  create_light(0.4, 0.4, 0.4,  14.0, 30.0,  -4.0);
  create_light(0.4, 0.4, 0.4,  20.0, 30.0,  10.0);

  defaultview.lookp.x = 0.0;
  defaultview.lookp.y = 2.0;
  defaultview.lookp.z = 10.0;

  defaultview.pos.x = 4.0;
  defaultview.pos.y = 5.0;
  defaultview.pos.z = 3.0;

  defaultview.up.x = 0.0;
  defaultview.up.y = 1.0;
  defaultview.up.z = 0.0;

  return;
}

void scene15()
{
  double sqrt3, x, y, z;
  surfaceT s1, s2, s3, s4;

  sqrt3 = sqrt(3.0);

  s1 = create_simple_surface(0.01, 0.2, 0.1, 0.9, 1.3, 6);
  s2 = create_simple_surface(0.0, 0.0, 0.0, 0.0, 0.0, 1);
  s3 = create_simple_surface(0.2, 0.2, 0.5, 0.0, 0.0, 6);
  s4 = create_checked_surface(s3, s2, 0.8);

  create_sphere(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-2.0, 2.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 0.0, 2.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 2.0, 2.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-3.0, 3.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, 3.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, 3.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 3.0, 3.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-4.0, 4.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-2.0, 4.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 0.0, 4.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 2.0, 4.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 4.0, 4.0*sqrt3, 0.0, 0.0, 0.0, 1.0, 1.0, s1);
  z = sqrt(8.0/3.0);
  y = 2.0 / sqrt3;
  create_sphere( 0.0, y, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-2.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 0.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 2.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-3.0, y+3.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, y+3.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, y+3.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 3.0, y+3.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  z = 2.0 * sqrt(8.0/3.0);
  y = 4.0 / sqrt3;
  create_sphere( 0.0, y, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-2.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 0.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 2.0, y+2.0*sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  z = 3.0 * sqrt(8.0/3.0);
  y = 6.0 / sqrt3;
  create_sphere( 0.0, y, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere(-1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
  create_sphere( 1.0, y+sqrt3, z, 0.0, 0.0, 1.0, 1.0, s1);
    		
  create_sphere( 0.0, 8.0 / sqrt3, 4.0 * sqrt(8.0/3.0), 0.0, 0.0, 1.0, 1.0, s1);
		
  create_square(0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 40.0, s4);

  create_light(0.0, 0.4, 0.4, -40.0, -20.0, 20.0);
  create_light(0.6, 0.0, 0.0, -20.0, -20.0, 20.0);
  create_light(0.0, 0.6, 0.0, 0.0, -20.0, 20.0);
  create_light(0.0, 0.0, 0.6, 20.0, -20.0, 20.0);
  create_light(0.4, 0.4, 0.0, 40.0, -20.0, 20.0);

  defaultview.lookp.x = 0.0;
  defaultview.lookp.y = 2.0 * sqrt3;
  defaultview.lookp.z = 2.75;

  defaultview.pos.x = 3.0;
  defaultview.pos.y = -10.0;
  defaultview.pos.z = 6.0;

  return;
}

void create_scene(int use_scene) {
  switch (use_scene) {
  case 1: scene1(); break;
  case 2: scene2(); break;
  case 3: scene3(); break;
  case 4: scene4(); break;
  case 5: scene5(); break;
  case 6: scene6(); break;
  case 7: scene7(); break;
  case 8: scene8(); break;
  case 9: scene9(); break;
  case 10: scene10(); break;
  case 11: scene11(); break;
  case 12: scene12(); break;
  case 13: scene13(); break;
  case 14: scene14(); break;
  case 15: scene15(); break;
  default:
    fprintf(stderr, "Unknown scene: %d\n", use_scene);
    exit(-1);
  }
}
        
