/* File: int.c
 * Time-stamp: <98/06/22 14:19:57 panic>
 * Author: Arne John Glenstrup <panic@diku.dk>
 * Description: An interpreter for a small subset of C
 */

#include "cint.h"

#ifndef __CMIX
#  define __CMIX(X)
#endif

#pragma cmix pure spectime: spectimeerror()
extern void spectimeerror(const char* errtxt);
#pragma cmix pure spectime: readProg()
extern Prog* readProg(char* filename);

Nams* globalNames;
Vals* globalValues;

Value assign(const char* name, Value v, Nams* names, Vals* values) {
  char s[100];
  while (names) {
    if (!strcmp(names->name, name)) 
      return values->value = v;
    names = names->next; values = values->next;
  }
  __CMIX(pure spectime)sprintf(s, "undefined variable `%s'\n", name);
  spectimeerror(s);
  __CMIX(spectime)exit(-1);
  return int2val(0);
}

const char* evalLVal(Exp* exp) {
  switch (exp->tag) {
  case Var : return exp->varName;
  default  : spectimeerror 
	       ("non-lvalue expression in lvalue context encountered\n");
  }
  return NULL;
}


Value evalExp(Exp* exp, Nams* names, Vals* values, Prog* p) {
  char s[100];
  switch (exp->tag) {
  case Const : return exp->constValue;
  case Var   :
    while (names) {
      if (!strcmp(names->name, exp->varName))
	return values->value;
      names = names->next; values = values->next;
    }
    __CMIX(pure spectime)sprintf(s, "undefined variable `%s'\n", exp->varName);
    spectimeerror(s);
    __CMIX(spectime) exit(-1);
    return int2val(0);
  case UnOp  :
    switch (exp->operat) {
    case UnMinus : return uminus(evalExp(exp->exp1, names, values, p));
    case UnNeg   : return negate(evalExp(exp->exp1, names, values, p));
    default      : return NULL;
    }
  case BinOp :
    switch (exp->operat) {
    case Plus    : return plus    (evalExp(exp->exp1, names, values, p),
				   evalExp(exp->exp2, names, values, p));
    case Minus   : return minus   (evalExp(exp->exp1, names, values, p),
				   evalExp(exp->exp2, names, values, p));
    case Times   : return multiply(evalExp(exp->exp1, names, values, p),
				   evalExp(exp->exp2, names, values, p));
    case Divide  : return divide  (evalExp(exp->exp1, names, values, p),
				   evalExp(exp->exp2, names, values, p));
    case EQ      : return eq      (evalExp(exp->exp1, names, values, p),
				   evalExp(exp->exp2, names, values, p));
    case NE      : return ne      (evalExp(exp->exp1, names, values, p),
				   evalExp(exp->exp2, names, values, p));
    case GT      : return gt      (evalExp(exp->exp1, names, values, p),
				   evalExp(exp->exp2, names, values, p));
    case LT      : return lt      (evalExp(exp->exp1, names, values, p),
				   evalExp(exp->exp2, names, values, p));
    case GE      : return ge      (evalExp(exp->exp1, names, values, p),
				   evalExp(exp->exp2, names, values, p));
    case LE      : return le      (evalExp(exp->exp1, names, values, p),
				   evalExp(exp->exp2, names, values, p));
    case Assign  : return assign  (evalLVal(exp->exp1),
				   evalExp(exp->exp2, names, values, p),
				   names, values);
    
    default      : return NULL;
    }
  }
  return NULL;
}
  

Result evalStmts(Stmt* stmt, Nams* names, Vals* values, Prog* p) {
  /* Evaluate stmt. If this causes a function return,
   * result.returnAction is set to true, and any return value is
   * returned in result.value.
   */
  Result result;
  Nams* tempName; Nams* newNames;
  Vals* tempValue; Vals* newValues;
  Decl* decl;
  while (stmt) {
    switch (stmt->tag) {
    case Expression :
      evalExp(stmt->exp, names, values, p);
      stmt = stmt->next;
      break;
    case IfElse     :
      
      /*****************************************************/
      /************* EXERCISE: CODE THIS UP ****************/
      spectimeerror("if-else-statements are not yet implemented.\n");
      __CMIX(spectime) exit(-1);
      /*****************************************************/
      
      break;
    case While      :
      if (val2boolean(evalExp(stmt->exp, names, values, p))) {
	result = evalStmts(stmt->whileStmts, names, values, p);
	if (result.returnAction) return result;
      } else
	stmt = stmt->next;
      break;
    case Return     :
      if (stmt->exp) result.value = evalExp(stmt->exp, names, values, p);
	result.returnAction = true;
      return result;
    case Compound   :
      decl = stmt->decls;
      newNames = names; newValues = values;
      while (decl) {
	tempName         = (Nams*)calloc(1, sizeof(Nams));
	tempName->next   = newNames;
	tempName->name   = decl->name;
	tempValue        = (Vals*)calloc(1, sizeof(Vals));
	tempValue->next  = newValues;
	tempValue->value = 0;
	newNames = tempName; newValues = tempValue;
	decl = decl->next;
      }
      result = evalStmts(stmt->stmts, newNames, newValues, p);
      if (result.returnAction) return result; else stmt = stmt->next;
      break;
    }
  }
  result.returnAction = false;
  return result;
}


Value evalFunc(Func* f, Actual* args, Prog* p) {

  Nams*   names  = globalNames;  /* local environment extends global */
  Vals*   values = globalValues; /* local environment extends global */
  Nams*   tempName; Vals* tempValue;
  Formal* params = f->params;

  /* Build environment from actual arguments and formal parameters */
  while (params) {
    tempName         = (Nams*)calloc(1, sizeof(Nams));
    tempName->next   = names;
    tempName->name   = params->name;
    names  = tempName; 
    if (!args) {
      error("too few arguments in function call\n");
      exit (-1);
    }
    tempValue        = (Vals*)calloc(1, sizeof(Vals));
    tempValue->next  = values;
    tempValue->value = args->value;
    values = tempValue;
    args   = args->next;
    params = params->next;
  }
  if (args) error("too many arguments in function call\n");

  /* Run function */
  return evalStmts(f->stmts, names, values, p).value;
  
}


Value evalProg(char* filename, Actual* args) {
  Prog* prog; Func* f;
  Value temp;
  prog = readProg(filename);
  f = prog->funcs;
  globalNames = NULL; globalValues = NULL;
  while (f != NULL && strcmp(f->name, "main") != 0) f = f->next;
  if (strcmp(f->name, "main") == 0) {
    temp = evalFunc(f, args, prog);
    return temp;
  } else
    spectimeerror("there must be a function called `main'.\n");
  return -1;
}
      
