proc fformat {typ} {
  switch $typ {
    char* {return %s}
    int {return %d}
    float {return %f}
    default {Autsch}
  }
}
########################################################################
proc genShowOptionValues {} {
  global D L argvString

  set res {}
  append res \
      "void\nshowOptionValues(void)\n\{\n"\
      "  int i;\n"

  if [info exist argvString] {
    append res \
	"\n"\
	"  printf(\"Full command line is:\\n`%s'\\n\","\
	" cmd.$argvString);\n"
  }

  foreach opt $L {
    ##### print flag value
    append res \
	"\n"\
	"  /***** $opt: $D($opt,usage) */\n"\
	"  if( !cmd.$D($opt,name)P ) \{\n"\
	"    printf(\"$opt not found.\\n\");\n"\
	"  \} else \{\n"\
	"    printf(\"$opt found:\\n\");\n"
    
    if { $D($opt,type)=="flag" } {
      append res \
	  "  \}\n"
      continue
    }
    
    ##### test of count
    append res \
	"    if( !cmd.$D($opt,name)C ) \{\n"\
	"      printf(\"  no values\\n\");\n"

    if { $D($opt,cmax)==1 } {
      ##### print single value
      append res \
	  "    \} else \{\n"\
	  "      printf(\"  value = `[fformat $D($opt,type)]'\\n\", "\
                                     	  "cmd.$D($opt,name));\n"\
	  "    \}\n"
    } else {
      ##### print multiple values
      append res \
	  "    \} else \{\n"\
	  "      printf(\"  values =\");\n"\
	  "      for(i=0; i<cmd.$D($opt,name)C; i++) \{\n"\
	  "        printf(\" `[fformat $D($opt,type)]'\", "\
	                                  "cmd.$D($opt,name)\[i\]);\n"\
	  "      \}\n"\
	  "      printf(\"\\n\");\n"\
	  "    \}\n"
    }
    append res \
	"  \}\n"
  }
  ##### take care of argc and argv
  append res \
      "  if( !cmd.argc ) \{\n"\
      "    printf(\"no remaining parameters in argv\\n\");\n"\
      "  \} else \{\n"\
      "    printf(\"argv =\");\n"\
      "    for(i=0; i<cmd.argc; i++) \{\n"\
      "      printf(\" `%s'\", cmd.argv\[i\]);\n"\
      "    \}\n"\
      "    printf(\"\\n\");\n"\
      "  \}\n"

  append res \
      "\}\n"\
      "/***********************************"\
      "***********************************/\n"
}
