//***************************************************************
//  smodlib.h - header file for voice manipulation library for
//          USR Sportster voice modem with speakerphone.
//  Author: Eugene Anikin (anikin@anikin.ddns.org - subject:"Speaker")
//***************************************************************
#ifdef SND_LIBR
#error sndlib.h was already included!!!!!!
#endif
#define SND_LIBR

#define BUFFER_SIZE 512
#define DTMF_SIZE 128
#define DLE 020
#define ETX 003

// Setup serial port parameters.
// This class takes care of the tty settings.
// It restores original settings on destruction.
class PortParam
{
   protected:
      struct termios told;
      char*  PortName;
      int    IsSetup;

   public:
      PortParam(char* PortName);
      ~PortParam(){ if(IsSetup) RestorePortMode();
                    if (PortName) delete PortName; };

      int SetPortMode(int speed); 
      int RestorePortMode();
};

class VModem 
{
   private:
      ConfigInfo* conf; // This will be just a pointer to passed object!!!
      PortParam* ttyParm;
      int isParent;     // True if this is a parent process.
      int ParentID;     // parent process ID (used by a child -- receiving proc)
      int ChildID;      // child process ID (used by a parent -- main program)
      int pipeD[2];     // communications pipe -- used to transfer data from
                      // receiving proc to the parent. 
      int StopChild;   // Flag to terminate child...
      char LastRec;    // Last character popped from the pipe.
                        // Used in GotSignal exclusively!!!
   protected:
      int fd; // File descriptor of the opened modem port...

      char Data[BUFFER_SIZE]; // The major receiving buffer.
      int  inData;     // Tells how much stuff we have in the Data buffer.

      char DTMF[DTMF_SIZE];      // Receiving buffer for DTMF signals
      int  inDTMF;      // Number of received DTMF signals

      char PubDTMF[PUBDTMFSIZE]; // "Public" DTMF signals. Those that are not  
      int  inPubDTMF;            // used internally.

      int  MsgExchTimeOut; // Time out in secs for the message exchange func
   public:
      VModem(){conf = NULL; ttyParm = NULL;};
      VModem(ConfigInfo* con);
      int     Init(ConfigInfo* con);
      virtual ~VModem();
   
      // If the port has some data in it, read it and stuff
      // all appropriate buffers
      void  ReadFromPort();
//      void  GotSignal2(){ StopChild = 1; };

      // Checks the buffer for the one of the messages in MsgStr,
      // 1 on success
      // 0 if did not find
      // -1 if found ERROR
      // If the SavTo is not NULL, all the data (up to the string
      // if found) will be saved to that buffer, and Num will have 
      // number of transferred bytes.
      // If DelOnNotFound is 0 and the MsgStr was not found,
      // data in the original buffer will not be deleted!
      // Naturally, SavTo buffer must be not shorter than Data
      int CheckBuffer( char* MsgStr, char* SavTo = NULL, int* Num = NULL, 
                     int DelOnNotFound = 1 );

      /* Starts read communication with the modem */
      /* returns 0 on failure */
      int  InitRead();
      void StopRead(){ close(fd); ttyParm->RestorePortMode();};

      // Returns handle of the opened serial port...
      int  GetPortFD(){return fd;};

      // Received data access functions
      void FlushRecBuffer(){ inData = 0; inDTMF = 0; LastRec = '\0';}
      int GetRecBytes(){ return inData; };
      int GetRecDTMF(){ return inDTMF; };

      // Function that is called to process DTMF signals
      // returns 
      // 0 - Signal processed, no addittional action necessary
      // 1 - abort data transfer
      virtual int ProcessDTMF();
      virtual int ProcessDTMFChar(char DTM);

      void  ResetPubDTMF(){inPubDTMF = 0;};
      int   GetPubDTMF(char* ARRAY);

      // Execute sequence of commands. If some commands
      // times out, will repeat it up to three times
      int ExecuteSequence( CommandSequence* CommandSeq );

      // Returns 1 - success
      // 0 - failure or time out
      
      // Message exchange function. 
      // Returns 1 - success
      // 0 - failure (got ERROR)
      // -1 - time out.
      // First param - what to send (add nl,cr)
      // Second param - what to expect (several choices separate by |)
      // Ex: MsgExchange("ATZ", "OK|VCON");
      int MsgExchange( char* MsgSnd, char* MsgExpect );

      // Check if the message has arrived and return all the info 
      // in the buffer preceeding this message.
      // If the buffer is NULL, check message only. The buffer
      // should be at least BUFFER_SIZE big.
      // 1 on success
      // 0 if did not find
      // -1 if found ERROR
      // First param - what to expect
      // Ex: MsgCheck("RING")
      int MsgCheck( char* MsgExpect, char* buffer = NULL, int* inbuf = NULL )
         {return CheckBuffer(MsgExpect, buffer, inbuf, 0);};

      // Write everything modem says up to MsgExpect to the file.
      // Will be used in the answering machine.        
      int GrabAFile( char* FName, char* MsgSend ,char* Expect,char* Until);
      
      // Opposite to the GrabAFile. Read the file and send it to the
      // modem.
      int SendAFile( char* FName, char* MsgSend ,char* Expect,char* Until);
};

