//************************************************************
//  smodlib.cpp - source file for voice manipulation library for
//          USR Sportster voice modem with speakerphone.
//************************************************************
#include "incall.h"

// Timer flag
ModemStatus MState;
GlobInit glb;
void GlobInit::PrepareAll()
{   
   struct sigaction act, oact;
   
   openlog( "gspk", LOG_CONS, LOG_DAEMON); 
   // Enable signal handling for the child. 
   act.sa_handler =  timeout;
   sigemptyset( &act.sa_mask );
   act.sa_flags = 0;

   #ifdef SA_RESTART
   act.sa_flags |= SA_RESTART;
   #endif

   if (sigaction( SIGALRM, &act, &oact) < 0) 
   {
      syslog(LOG_CRIT,"Cannot catch SIGALRM");
      return;
   }
};

void GlobInit::CloseAll()
{
   closelog();
}

int iTimedOut = 0;
void timeout(int)
{
   iTimedOut = 1;
};

//***************************************************************
//***************************************************************
//
//  class PortParam
//
//***************************************************************
//***************************************************************
PortParam::PortParam(char* PName)
{
   IsSetup = 0;
   PortName = NULL;
   if (PName == NULL) return;
   PortName = new char[strlen(PName) + 1];
   strcpy(PortName, PName);
};

int PortParam::SetPortMode(int speed)
{
   struct termios tdes;
   int fd;

   if (PortName == NULL)
   {
      syslog(LOG_CRIT,"Port name is not defined in PortParam::SetPortMode!");
      return 0;
   }

   // Open port 
   fd = open( PortName, O_RDWR | O_NONBLOCK);
   if (fd == -1) 
   {
      syslog(LOG_CRIT,"Unable to open modem port:");
      syslog(LOG_CRIT,PortName);
      return 0;
   }

   if (!isatty(fd)) 
   {
      syslog(LOG_CRIT,"Specified device is not a terminal:");
      syslog(LOG_CRIT,PortName);
      close(fd);
      return 0;
   }

   if (tcgetattr ( fd, &told ) < 0) 
   {
      syslog(LOG_CRIT,"tcgetattr failure");
      close(fd);
      return 0;
   }

   if (tcgetattr ( fd, &tdes ) < 0) 
   {
      syslog(LOG_CRIT,"tcgetattr failure");
      close(fd);
      return 0;
   }
   
   tdes.c_iflag = IGNBRK  | IGNPAR; 
   // BRKINT  | PARMRK | INPCK | ISTRIP | INLCR | IGNCR | ICRNL | 
   // IUCLC | IXON | IXANY | IXOFF | IMAXBEL 

   tdes.c_oflag =  0;
   // OPOST | OLCUC | ONLCR | OCRNL | ONOCR | ONLRET | OFILL | 
   // OFDEL | NLDLY | NL0 | NL1 | CRDLY | CR0 | CR1 | CR2 | CR3 | 
   // TABDLY | TAB0 | TAB1 | TAB2 | TAB3 | XTABS | BSDLY | BS0 | 
   // BS1 | VTDLY | VT0 | VT1 | FFDLY | FF0 | FF1

   tdes.c_cflag = CS8 | HUPCL | CLOCAL | CRTSCTS | CREAD;
   // CBAUD | EXTA | EXTB | CSIZE | CS5 | CS6 | CS7 | CSTOPB | 
   // CREAD | PARENB | PARODD | CIBAUD | 

   switch (speed) 
   {
      case 0: tdes.c_cflag |= B0; break;
      case 50: tdes.c_cflag |= B50; break;
      case 75: tdes.c_cflag |= B75; break;
      case 110: tdes.c_cflag |= B110; break;
      case 134: tdes.c_cflag |= B134; break;
      case 150: tdes.c_cflag |= B150; break;
      case 200: tdes.c_cflag |= B200; break;
      case 300: tdes.c_cflag |= B300; break;
      case 600: tdes.c_cflag |= B600; break;
      case 1200: tdes.c_cflag |= B1200; break;
      case 1800: tdes.c_cflag |= B1800; break;
      case 2400: tdes.c_cflag |= B2400; break;
      case 4800: tdes.c_cflag |= B4800; break;
      case 9600: tdes.c_cflag |= B9600; break;
      case 19200: tdes.c_cflag |= B19200; break;
      case 38400: tdes.c_cflag |= B38400; break;
#ifdef B57600
      case 57600: tdes.c_cflag |= B57600; break;
#endif
#ifdef B115200
      case 115200: tdes.c_cflag |= B115200; break;
#endif
#ifdef B230400
      case 230400: tdes.c_cflag |= B230400; break;
#endif
#ifdef B460800
      case 460800: tdes.c_cflag |= B460800; break;
#endif
      default: tdes.c_cflag |= B38400; break;
   };

   tdes.c_lflag = 0;
   // ISIG | ICANON | XCASE | ECHO | ECHOE | ECHOK | ECHONL | 
   // NOFLSH | TOSTOP | ECHOCTL | ECHOPRT | ECHOKE | FLUSHO | 
   // PENDIN | IEXTEN 


   if (tcsetattr ( fd, TCSANOW, &tdes ) < 0) 
   {
      syslog(LOG_CRIT,"tcsetattr failure: Unable to set port settings!");
      close(fd);
      return 0;
   }

   close(fd);
   IsSetup = 1;
   return 1;

}; 

int PortParam::RestorePortMode()
{
   int fd;

   if (!IsSetup) return 1;

   if (PortName == NULL)
   {
      syslog(LOG_WARNING,"Port name is not defined in PortParam::RestorePortMode!");
      return 0;
   }

   // Open port 
   fd = open( PortName, O_RDWR | O_NONBLOCK);
   if (fd == -1) 
   {
      syslog(LOG_WARNING,"Unable to open modem port:");
      syslog(LOG_WARNING,PortName);
      return 0;
   }

   if (!isatty(fd)) 
   {
      syslog(LOG_WARNING,"Specified device is not a terminal:");
      syslog(LOG_WARNING,PortName);
      close(fd);
      return 0;
   }

   if (tcsetattr ( fd, TCSANOW, &told ) < 0) 
   {
      syslog(LOG_CRIT,"tcsetattr failure: Unable to set port settings!");
      close(fd);
      return 0;
   }

   close(fd);
   IsSetup = 0;
   return 1;
};


//***************************************************************
//***************************************************************
//
//  global functions
//
//***************************************************************
//***************************************************************
char* memstr( char* where, char* what, int howmuch)
{
   char* ptrf;
   int i,j;

   if (strlen(what) >= 1) 
   {
      for (i = 0; i < howmuch; i++) 
      {
         if (what[0] == where[i]) 
         {
            // compare further...
            j = i + 1;
            ptrf = &(what[1]);
            while (*ptrf != '\0' && *ptrf == where[j] && 
               j < howmuch ) ptrf++,j++;
            if (*ptrf == '\0') return &(where[i]);
 
         }
      }
      return NULL;
   }
   return where;
}

//***************************************************************
//***************************************************************
//
//  class VModem
//
//***************************************************************
//***************************************************************
VModem::VModem(ConfigInfo* con) 
{
   if (con == NULL)
   {
      syslog(LOG_ERR, "Empty parameter passed into VModem!");
      exit(-1);
   }
   conf = con;
   inData = 0;
   inDTMF = 0;
   inPubDTMF = 0;
   MsgExchTimeOut = 3; // Three seconds time out for now...
   StopChild = 0;
   ttyParm = new PortParam(conf->SerialPort);
};

int VModem::Init(ConfigInfo* con) 
{
   if (con == NULL)
   {
      syslog(LOG_ERR, "Empty parameter passed into VModem!");
      return 0;
   }
   conf = con;
   inData = 0;
   inDTMF = 0;
   inPubDTMF = 0;
   MsgExchTimeOut = 3; // Three seconds time out for now...
   StopChild = 0;
   ttyParm = new PortParam(conf->SerialPort);
   return 1;
};

VModem::~VModem()
{
   if (isParent)
   {
      StopRead(); // kill the child process
      ttyParm->RestorePortMode();
   }
   delete ttyParm;
};

//static VModem* TThis;

//static void dispatchsig(int)
//{
//   if (TThis) TThis->GotSignal();
//};
//
//static void finishchild(int)
//{
//   if (TThis) TThis->GotSignal2();
//};

int VModem::InitRead()
{
//   char buf[5]; // Buffer for the characters read from the port. 
             // For now, read one at a time.

//   struct sigaction act, oact;

   // Set the port to more appropriate mode -- RAW!!!!
   if (ttyParm->SetPortMode(conf->PortSpeed) == 0) 
   {
      return 0;
   }

   // Open port for reading...
   fd = open(conf->SerialPort, O_RDWR/* | O_NONBLOCK*/);
   if (fd == -1) 
   {
      syslog(LOG_CRIT,"Unable to open modem port for reading");
      return 0;
   }
   {
      struct termios tdes;

      if (tcgetattr ( fd, &tdes ) < 0) 
      {
         syslog(LOG_CRIT,"tcgetattr failure");
         close(fd);
         return 0;
      }
      
      tdes.c_iflag = IGNBRK  | IGNPAR; 
      tdes.c_oflag =  0;
      tdes.c_cflag = CS8 | HUPCL | CLOCAL | CRTSCTS | CREAD;

      switch (conf->PortSpeed) 
      {
         case 0: tdes.c_cflag |= B0; break;
         case 50: tdes.c_cflag |= B50; break;
         case 75: tdes.c_cflag |= B75; break;
         case 110: tdes.c_cflag |= B110; break;
         case 134: tdes.c_cflag |= B134; break;
         case 150: tdes.c_cflag |= B150; break;
         case 200: tdes.c_cflag |= B200; break;
         case 300: tdes.c_cflag |= B300; break;
         case 600: tdes.c_cflag |= B600; break;
         case 1200: tdes.c_cflag |= B1200; break;
         case 1800: tdes.c_cflag |= B1800; break;
         case 2400: tdes.c_cflag |= B2400; break;
         case 4800: tdes.c_cflag |= B4800; break;
         case 9600: tdes.c_cflag |= B9600; break;
         case 19200: tdes.c_cflag |= B19200; break;
         case 38400: tdes.c_cflag |= B38400; break;
#ifdef B57600
         case 57600: tdes.c_cflag |= B57600; break;
#endif
#ifdef B115200
         case 115200: tdes.c_cflag |= B115200; break;
#endif
#ifdef B230400
         case 230400: tdes.c_cflag |= B230400; break;
#endif
#ifdef B460800
         case 460800: tdes.c_cflag |= B460800; break;
#endif
         default: tdes.c_cflag |= B38400; break;
      };

      tdes.c_lflag = 0;


      if (tcsetattr ( fd, TCSANOW, &tdes ) < 0) 
      {
         syslog(LOG_CRIT,"tcsetattr failure: Unable to set port settings!");
         close(fd);
         return 0;
      }
   }

   return 1;
   // Create a pipe from the child to the parent -- this way we transfer info
   // received from the modem. Sorry for these complications, I just
   // want to empty the modem buffer as soon as possible.
//   if (pipe(pipeD) < 0) 
//   {
//      syslog(LOG_CRIT,"Cannot create a pipe -- Geeeez I hope this is not DOS!");
//      return 0;
//   }
//
//   TThis = this;
//
//   // Create a thread that will always read the port.
//   ChildID = fork();
//   if (ChildID == -1) 
//   {
//      syslog(LOG_CRIT,"Can't fork -- sorry!");
//      return 0;
//   }
//
//   // If this is a parent
//   if (ChildID != 0)
//   {
//
//      // Enable signal handling for the parent. 
//      act.sa_handler =  dispatchsig;
//      sigemptyset( &act.sa_mask );
//      act.sa_flags = 0;
//
//      #ifdef SA_RESTART
//      act.sa_flags |= SA_RESTART;
//      #endif
//
//      if (sigaction( SIGUSR1, &act, &oact) < 0) 
//      {
//         syslog(LOG_CRIT,"Cannot catch SIGUSR1");
//         return 0;
//      }
//
//      close(pipeD[1]);
//
//      isParent = 1;
//      return 1;
//   }
//
//   // Child closes receiving end ...
//   close(pipeD[0]);
//   isParent = 0;
//
//   // Enable signal handling for the child. 
//   act.sa_handler =  finishchild;
//   sigemptyset( &act.sa_mask );
//   act.sa_flags = 0;
//
//   #ifdef SA_INTERRUPT
//   act.sa_flags |= SA_INTERRUPT;
//   #endif
//
//   if (sigaction( SIGINT, &act, &oact) < 0) 
//   {
//      syslog(LOG_CRIT,"Cannot catch SIGINT");
//      return 0;
//   }
//
//   ParentID = getppid();
//
//   do 
//   {
//      if (read(fd, buf, 1) == 1) 
//      {
//         write(pipeD[1], buf, 1);
//         kill(ParentID, SIGUSR1);
//
//         buf[1] = '\0';
//         //syslog(LOG_DEBUG, "Pushed into pipe:");
//         //syslog(LOG_DEBUG, buf );
//      }
//   } while (StopChild == 0);
//
//   close(fd);
//   syslog(LOG_DEBUG,"Child terminates.");
//   exit(0);
};


void VModem::ReadFromPort()
{
   char buf[256];
   int numread;
   int retval;
   fd_set rset;
   struct timeval tmdly;

   tmdly.tv_sec = 0;
   tmdly.tv_usec = 0;

   FD_ZERO(&rset);
   FD_SET(GetPortFD(), &rset);

   retval = select(1+GetPortFD(), &rset, NULL, NULL, &tmdly);
   if ( retval < 1 ) return;

   numread = read( GetPortFD(), buf, sizeof(buf)-1);
   if (numread > 0) 
   {
      buf[numread] = '\0';
      //syslog(LOG_DEBUG, "Got:");
      //syslog(LOG_DEBUG, buf );

//if (buf[0] == DLE)
//putchar('*');
      
      // Check for DTMF signals.
      // They always start with DLE
      if (LastRec == DLE)
      {
         memmove(&(buf[1]), buf, numread);
         numread++;
         buf[0] = DLE;
      }

      LastRec = DLE;

      for ( int i = 0; i < numread-1; i++ )
      {
         if (buf[i] == DLE)
         {
            // DLE was detected! Decode it.
            if ( buf[i+1] == DLE ) // Received double DLE, just make it one
            {
               if ( i+2 == numread ) LastRec = 0; // Last DLE not to be counted
               memmove(&buf[i],&buf[i+1],numread - i - 1);
               numread--;
            } else  // DTMF command, decode it.
            {
               DTMF[inDTMF] = buf[i+1];
               inDTMF++;
               if ( numread - i - 2 > 0 ) // Remove DTMF from the data stream
               {
                  memmove(&buf[i],&buf[i+2],numread - i - 2);
                  i--;
               }
               numread = numread - 2;
            }
         }
      }

      if ( numread == 0) 
      {
         LastRec = 0;
         return;
      }

      if ( buf[numread-1] != DLE ) LastRec = 0;

      if (LastRec == DLE) return;
   
      // We need to add received data to the buffer...
      // Check for overflow situation
      if ((unsigned int)(inData + numread + 2) > sizeof(Data)) 
      {
         syslog(LOG_WARNING,"Incoming buffer overflow, ... truncating");
         char* to = Data;
         char* from = Data + sizeof(Data)/2;
         for (unsigned int i = 0; i < sizeof(Data); i++)
         {
            *to++ = *from++;
         }
         inData -= sizeof(Data)/2;  
      }
   
      for (int i = 0; i < numread; i++) 
      {
         Data[inData++] = buf[i];
      }
   }
};

// Execute sequence of commands. If some commands
// times out, will repeat it up to three times
int VModem::ExecuteSequence( CommandSequence* CommandSeq )
{
   int retval;
   CommandSequence* cmd = CommandSeq;
   while( cmd )
   {
      retval = 0;
      for (int i = 0; i < 3; i++)
      {
         if (MsgExchange(cmd->GetCommand(), cmd->GetAnswer()) >= 0)
         {
            retval = 1;
            break;
         }
      }
      if (!retval) return 0;
      cmd = cmd->GetNext();
   }
   return 1;
}

int VModem::MsgExchange( char* MsgSnd, char* MsgExpect )
{
   PREP_ALARM;
   char newline[3] = {'\015','\012','\0'};
   int ExchComplete = 0;
   char allbuf[256];
   strcpy(allbuf, MsgSnd);
   strcat(allbuf, newline);
//   sigset_t usrmask, oldmask;

   FlushRecBuffer();
   CHECK_ABORT_0;

   syslog(LOG_DEBUG,"Sending:");
   syslog(LOG_DEBUG,MsgSnd);

//   sigemptyset( &usrmask );
//   sigaddset(&usrmask, SIGUSR1 );
//   if (sigprocmask( SIG_BLOCK,&usrmask, &oldmask) < 0)
//      syslog(LOG_ERR, "Unable to set a signal mask!");

   write( GetPortFD(), allbuf, strlen(allbuf));
// write( GetPortFD(), buf, sizeof(buf));

//   if (sigprocmask( SIG_SETMASK,&oldmask, NULL) < 0)
//      syslog(LOG_ERR, "Unable to restore a signal mask!");
   
   CHECK_ABORT_0;

   SET_ALARM(MsgExchTimeOut);

   usleep(24000000/conf->PortSpeed); 
   do 
   {
      ExchComplete = CheckBuffer( MsgExpect );

      if (MState.AbortCommand)
      {
         RESET_ALARM;
         return 0;
      }

      // sleep long enough to receive at least 2 bytes.
      usleep(24000000/conf->PortSpeed); 
   } while (!ExchComplete && !iTimedOut);

   if (iTimedOut) 
   {
      RESET_ALARM;
      syslog(LOG_ERR,"Time out in MsgExchange!\n");
      return -1;
   }

   RESET_ALARM;
   if (ExchComplete == -1) 
   {
      syslog(LOG_ERR, "Error received! Could be incompatible modem!");
      return 0;
   };
   return 1;
}


int VModem::CheckBuffer( char* MsgStr, char* SavTo, int* Num, int DelOnNF )
{
   int retval = 0;
   int matchlen;
   char srchMsk[512];
   char *ptr = MsgStr;
   char *ptrto, *found;
//   sigset_t usrmask, oldmask;

   ReadFromPort();
   
   if (Num != NULL) *Num = 0;

//   sigemptyset( &usrmask );
//   sigaddset(&usrmask, SIGUSR1 );

//   if (sigprocmask( SIG_BLOCK,&usrmask, &oldmask) < 0)
//      syslog(LOG_ERR, "Unable to set a signal mask!");
   
   Data[inData] = '\0';
   
//   if (!DelOnNF && inData > 2)
//   {
//      syslog(LOG_DEBUG,"In buffer of Check Buffer:");
//      syslog(LOG_DEBUG,Data);
//   }
   
   matchlen = 7; // Sizeof --vvvvvvvvv
   if ((found = memstr(Data, ERROR_CMD, inData)) == NULL) 
   {
      while ( *ptr != '\0' )
      {
         // Extract the new line to search...
         ptrto = srchMsk;

         while (*ptr != '\0' && *ptr != '|')
         {
            *ptrto = *ptr;
            ptrto++; ptr++;
         }

         // Append cr lf to the end of mask...
         *ptrto++ = '\015';
         *ptrto++ = '\012';
         *ptrto = '\0';

         if (*ptr == '|') ptr++;
         
         matchlen = strlen(srchMsk);
         if ((found = memstr(Data, srchMsk, inData)) != NULL) 
         {
            retval = 1;
            break;
         }
      }
   } else retval = -1;

   // Save all info up to the found string
   if (SavTo != NULL) 
   {
      int size;

      if (found == NULL) 
      {
         size = ( inData > 100 )?inData - 100: 0;
      } else 
      {
         size = (found - Data);
      }

      for(*Num = 0; (*Num) < size; (*Num)++) 
      {
         SavTo[*Num] = Data[*Num];
      }
   }

   // Remove all info in the buffer up to this message
   if ( found != NULL ) 
   {
      int size = matchlen + ( found - Data );

      if ( size > 1 ) 
      {
         Data[size-2] = '\0';
         syslog(LOG_DEBUG,"Received:");
         syslog(LOG_DEBUG,found);
         
         // Surgical operation, removing the message:
         // If you are brave, you can use strncpy ;-)
         for (int i = 0; i < (inData - size); i++) 
         {
            Data[i] = Data[i+size];
         }

         inData -= size;
      } else
      {
         syslog(LOG_ERR,"Detect line length is not correct!");
      }
   } else 
   {
      if ( Num != NULL &&  *Num > 0 && DelOnNF) 
      {
         for (int i = 0; i < (inData - (*Num)); i++) 
         {
            Data[i] = Data[i + *Num]; 
         }
         inData -= (*Num);
      }
   }
 
//   if (sigprocmask( SIG_SETMASK,&oldmask, NULL) < 0)
//   {
//      syslog(LOG_ERR, "Unable to restore a signal mask!");
//   }
   return retval;
};

// Returns 0 - some fatal error
//         -1 - time out
//         1 - success
//         -2 - aborted (by DTMF signal, etc.)
int VModem::GrabAFile( char* FName,
                       char* MsgSnd, 
                       char* MsgExpect, 
                       char* MsgUntil )
{
   PREP_ALARM;
//   sigset_t usrmask, oldmask;
   char datbuf[BUFFER_SIZE+1];
   char newline[3] = {'\015','\012','\0'};
   int ExchComplete = 0;
   char allbuf[256];
   int sfp;
   
   MState.StopTransmit = 0;
   MState.Recording = 1;

   sfp = creat(FName, 0644);
   if ( sfp == -1 )
   {
      syslog(LOG_ERR, "Unable to create the file:" );
      syslog(LOG_ERR, FName );
      return 0;
   }

   strcpy(allbuf, MsgSnd);
   strcat(allbuf, newline);

   iTimedOut = 0;
   CHECK_ABORT_0;
   if (MState.StopTransmit) return -2;
   FlushRecBuffer();
   syslog(LOG_DEBUG,"Sending:");
   syslog(LOG_DEBUG,MsgSnd);

//   sigemptyset( &usrmask );
//   sigaddset(&usrmask, SIGUSR1 );
//   if (sigprocmask( SIG_BLOCK,&usrmask, &oldmask) < 0)
//      syslog(LOG_ERR, "Unable to set a signal mask!");

   write( GetPortFD(), allbuf, strlen(allbuf));

//   if (sigprocmask( SIG_SETMASK,&oldmask, NULL) < 0)
//      syslog(LOG_ERR, "Unable to restore a signal mask!");

   CHECK_ABORT_0;
   if (MState.StopTransmit) return -2;
   
   SET_ALARM(MsgExchTimeOut);

   usleep(24000000/conf->PortSpeed); 
   do 
   {
      ExchComplete = CheckBuffer( MsgExpect );

      if (MState.AbortCommand || MState.StopTransmit)
      {
         RESET_ALARM;
         close( sfp );
         return -2;
      }

      // sleep long enough to receive at least 2 bytes.
      usleep(24000000/conf->PortSpeed); 
   } while (!ExchComplete && !iTimedOut);

   if (iTimedOut) 
   {
      RESET_ALARM;
      syslog(LOG_ERR,"Time out in MsgExchange!\n");
      close( sfp );
      return -1;
   }

   RESET_ALARM;

   if (ExchComplete == -1) 
   {
      syslog(LOG_ERR, "Error received! Could be incompatible modem!");
      close( sfp );
      return 0;
   }

   // We should have received CONNECT by now. Get all the data from the
   // modem and write to the file.
   int AbortTransfer = 0;
   int AbortSent = 0;
   do 
   {
      int bytesRec;
      ExchComplete = CheckBuffer( MsgUntil, datbuf, &bytesRec );

      if (bytesRec != 0) 
      {
//         sigemptyset( &usrmask );
//         sigaddset(&usrmask, SIGUSR1 );
//         sigaddset(&usrmask, SIGURG );
//         if (sigprocmask( SIG_BLOCK,&usrmask, &oldmask) < 0)
//            syslog(LOG_ERR, "Unable to set a signal mask!");

         write( sfp, datbuf, bytesRec);

         if ((MState.AbortCommand || MState.StopTransmit) && !AbortSent)
         {
            char done[2] = { DLE, ETX };
            AbortSent = 1;
            write( GetPortFD(), done, 2);
         }

//         if (sigprocmask( SIG_SETMASK,&oldmask, NULL) < 0)
//            syslog(LOG_ERR, "Unable to restore a signal mask!");
         
      }
      
      if (inDTMF)
      {
         AbortTransfer = ProcessDTMF();
      }

      // sleep long enough to receive at least 2 bytes.
      usleep(24000000/conf->PortSpeed); 
   } while (!ExchComplete && !AbortTransfer);


   close( sfp );
   return 1;
}


int VModem::ProcessDTMF()
{
//   sigset_t usrmask, oldmask;
   char localDTMF[DTMF_SIZE];
   int inlocalDTMF;
   int retval = 0;

//   sigemptyset( &usrmask );
//   sigaddset(&usrmask, SIGUSR1 );
//   if (sigprocmask( SIG_BLOCK,&usrmask, &oldmask) < 0)
//      syslog(LOG_ERR, "Unable to set a signal mask!");

   inlocalDTMF = inDTMF;
   memcpy(localDTMF, DTMF, inDTMF);
   inDTMF = 0;

//   if (sigprocmask( SIG_SETMASK,&oldmask, NULL) < 0)
//      syslog(LOG_ERR, "Unable to restore a signal mask!");

   for (int i = 0; i < inlocalDTMF; i++)
   {
      retval = ProcessDTMFChar( localDTMF[i] );
      if (retval) break;
   }

   return retval;
}


int VModem::ProcessDTMFChar(char DTM)
{
//   sigset_t usrmask, oldmask;
   char buf[256];
   int retval = 0;

   sprintf( buf, "Received DTMF signal:'%c'",DTM );
   syslog(LOG_DEBUG,buf);

   switch (DTM)
   {
      case 'q': 
      case 's': 
//         sigemptyset( &usrmask );
//         sigaddset(&usrmask, SIGUSR1 );
//         if (sigprocmask( SIG_BLOCK,&usrmask, &oldmask) < 0)
//            syslog(LOG_ERR, "Unable to set a signal mask!");

         write( GetPortFD(), "!", 1); // Just abort reception :-)

//         if (sigprocmask( SIG_SETMASK,&oldmask, NULL) < 0)
//            syslog(LOG_ERR, "Unable to restore a signal mask!");

         if (inPubDTMF >= 0 && inPubDTMF < PUBDTMFSIZE)
            PubDTMF[inPubDTMF++] = DTM;   
      break;
      case ETX:
         retval = 1;
      break;
      case '#': 
         MState.StopTransmit = 1;
      case '*': 
      case '0': 
      case '1': 
      case '2': 
      case '3': 
      case '4': 
      case '5': 
      case '6': 
      case '7': 
      case '8': 
      case '9': 
      case 'A': 
      case 'B': 
      case 'C': 
      case 'D': 
      case 'a': 
      case 'b': 
      case 'c': 
      case 'd': 
      case 'e': 
      case 'f': 
      case 'h': 
         if (inPubDTMF >= 0 && inPubDTMF < PUBDTMFSIZE)
            PubDTMF[inPubDTMF++] = DTM;   
         if (!MState.Recording && !MState.IgnoreDTMF)
         {
            MState.StopTransmit = 1;
         }
      break;
      default:
      break;
   }
   return retval;
}

int VModem::GetPubDTMF(char* ARRAY)
{ 
   ProcessDTMF(); /* Grab additional DTMF characters */
   for(int i=0; i<inPubDTMF; i++) ARRAY[i]=PubDTMF[i]; 
   return inPubDTMF;
}


//
// Double all DLE's in the buffer and remove frames damaged by
// USR bugs.
//
void ProcessBuffer(unsigned char* datbuf, int& bytesRec, int LastRec, 
                   unsigned char* sndbuf, int& bytesSnd, int CheckGSM)
{
   int frameptr = 0;
   int srcptr = 0;
   int dstptr = 0;

   while ( frameptr + 37 < bytesRec )
   {
      if (CheckGSM)
      {
         // Check completeness of GSM Frame
         while(!((datbuf[frameptr+36] == 0xA5 && datbuf[frameptr+37] == 0xA5) &&
                (datbuf[frameptr] == 0xB6 && datbuf[frameptr+1] == 0xB6 ||
                 datbuf[frameptr] == 0xFE && datbuf[frameptr+1] == 0xFE)))
         {
            frameptr++;
            // Just check that we did not go over board
            if ( frameptr + 38 >= bytesRec ) break;
         }
         if ( frameptr + 38 >= bytesRec ) break;
      }
      // Transfer all the data...
      for ( srcptr = frameptr; srcptr < frameptr + 38; srcptr++ )
      {
         sndbuf[dstptr++] = datbuf[srcptr];
         if ( datbuf[srcptr] == DLE )
         {
            sndbuf[dstptr++] = DLE;
         }
      } 
      
      frameptr += 38;  
   }
   
   if (srcptr < bytesRec)
      memmove(datbuf, &(datbuf[srcptr]), bytesRec - srcptr);

   bytesRec = bytesRec - srcptr;
   bytesSnd = dstptr;

   if ( LastRec == 0 )
      bytesRec = 0;
};

// Returns 0 - some fatal error
//         -1 - time out
//         1 - success
//         -2 - aborted (by DTMF signal, etc.)
int VModem::SendAFile( char* FName,
                       char* MsgSnd, 
                       char* MsgExpect, 
                       char* MsgUntil )
{
   PREP_ALARM;
//   sigset_t usrmask, oldmask;
   char datbuf[BUFFER_SIZE/4];
   char sndbuf[BUFFER_SIZE/2];
   char newline[3] = {'\015','\012','\0'};
   int ExchComplete = 0;
   char allbuf[256];
   int sfp;

   MState.StopTransmit = 0;
   MState.Recording = 0;

   sfp = open(FName, O_RDONLY);
   if ( sfp == -1 )
   {
      syslog(LOG_ERR, "Unable to open the file:" );
      syslog(LOG_ERR, FName );
      return 0;
   }

   strcpy(allbuf, MsgSnd);
   strcat(allbuf, newline);

   iTimedOut = 0;
   FlushRecBuffer();
   syslog(LOG_DEBUG,"Sending:");
   syslog(LOG_DEBUG,MsgSnd);

   ABORT_CLOSE;
//   sigemptyset( &usrmask );
//   sigaddset(&usrmask, SIGUSR1 );
//   if (sigprocmask( SIG_BLOCK,&usrmask, &oldmask) < 0)
//      syslog(LOG_ERR, "Unable to set a signal mask!");

   write( GetPortFD(), allbuf, strlen(allbuf));

//   if (sigprocmask( SIG_SETMASK,&oldmask, NULL) < 0)
//      syslog(LOG_ERR, "Unable to restore a signal mask!");
  
   ABORT_CLOSE;

   SET_ALARM(MsgExchTimeOut);

   usleep(24000000/conf->PortSpeed); 
   do 
   {
      ExchComplete = CheckBuffer( MsgExpect );

      if (MState.AbortCommand || MState.StopTransmit)
      {
         RESET_ALARM;
         close(sfp);
         return 0;
      }
      // sleep long enough to receive at least 2 bytes.
      usleep(24000000/conf->PortSpeed); 
   } while (!ExchComplete && !iTimedOut);

   if (iTimedOut) 
   {
      RESET_ALARM;
      syslog(LOG_ERR,"Time out in MsgExchange!\n");
      close( sfp );
      return -1;
   }

   RESET_ALARM;

   ABORT_CLOSE;

   if (ExchComplete == -1) 
   {
      syslog(LOG_ERR, "Error received! Could be incompatible modem!");
      close( sfp );
      return 0;
   }

   // We should have received CONNECT by now. Get all the data from the
   // file and write to the modem.
   int AbortTransfer = 0;
   int bytesRec = 0;
   int bytesSnd;
   int inBuffer = 0;
   int complete = 0;

   do 
   {
      if ( inBuffer > 38 ) inBuffer = 0; // Flush overfilled buffer...
      bytesRec = read(sfp, &(datbuf[inBuffer]), sizeof(datbuf) - inBuffer - 1);
      inBuffer += bytesRec;
      ProcessBuffer((unsigned char*)datbuf, inBuffer, 
                  bytesRec, (unsigned char*)sndbuf, bytesSnd, conf->CheckGSM);

      if (bytesSnd != 0 && !(MState.AbortCommand || MState.StopTransmit)) 
      {
//            sigemptyset( &usrmask );
//            sigaddset(&usrmask, SIGUSR1 );
//            sigaddset(&usrmask, SIGURG );
//            if (sigprocmask( SIG_BLOCK,&usrmask, &oldmask) < 0)
//               syslog(LOG_ERR, "Unable to set a signal mask!");

            write( GetPortFD(), sndbuf, bytesSnd);

//            if (sigprocmask( SIG_SETMASK,&oldmask, NULL) < 0)
//               syslog(LOG_ERR, "Unable to restore a signal mask!");
      } else 
      {
         if ( ! complete )
         {
            char done[2] = { DLE, ETX };
//            sigemptyset( &usrmask );
//            sigaddset(&usrmask, SIGUSR1 );
//            sigaddset(&usrmask, SIGURG );
//            if (sigprocmask( SIG_BLOCK,&usrmask, &oldmask) < 0)
//               syslog(LOG_ERR, "Unable to set a signal mask!");

            write( GetPortFD(), done, 2);

//            if (sigprocmask( SIG_SETMASK,&oldmask, NULL) < 0)
//               syslog(LOG_ERR, "Unable to restore a signal mask!");
            complete = 1;
         }
      }
      
      ExchComplete = CheckBuffer( MsgUntil );

      if (inDTMF)
      {
         AbortTransfer = ProcessDTMF();
      }
   } while ( !ExchComplete && !AbortTransfer);


   close( sfp );
   return 1;
}

