//************************************************************
// Include all files necessary for the voice modem operation
//************************************************************
// 

#include <stdio.h>
#include <string.h>
#include <fcntl.h>

#include <termios.h>

#include <unistd.h>
#include <time.h>

#ifndef _NOSTDLIB_H
#include <stdlib.h>
#endif

#include <errno.h>
#include <signal.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netdb.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <syslog.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifdef NAME_MAX
#define MAXFILENAME (NAME_MAX+1)
#else
#define MAXFILENAME 255;
#endif

#define PUBDTMFSIZE 1024

// Timer flag
extern int iTimedOut;
void timeout(int);

#include "config.h"
#include "cmdsequence.h"
#include "commandset.h"
#include "smodlib.h"
#include "locks.h"

// Error response should include new line (temporarily)
#define ERROR_CMD                "ERROR\015\012"

#define  THREE_RETRY for(i=0;i<3&&(ret==-1||i==0);i++)
#define  MIN(x,y) (((x)<(y))?(x):(y))

#define  PREP_ALARM int oldTime, oldTimeOut, pendingAl;

// Set a new alarm and save info about pending one if necessary
#define  SET_ALARM(x)   oldTime = alarm(MsgExchTimeOut);\
                        oldTimeOut = iTimedOut;\
                        iTimedOut = 0;\
                        if (oldTime != 0) {\
                           pendingAl = 1;\
                           oldTime -= MsgExchTimeOut;\
                        } else pendingAl = 0; 

#define  RESET_ALARM iTimedOut = alarm(0);\
                     if (pendingAl){\
                        oldTime += iTimedOut;\
                        if (oldTime > 0){\
                           iTimedOut = oldTimeOut;\
                           alarm(oldTime);\
                        } else iTimedOut = 1;\
                     } else iTimedOut = oldTimeOut;

class GlobInit
{
   private:
      void PrepareAll(); // Global init function
      void CloseAll(); // Global init function
   public:
      GlobInit(){PrepareAll();}
      ~GlobInit(){CloseAll();}
};


/*****************************************************************
** Run-time status of the modem
*****************************************************************/
class ModemStatus
{
   public:
//      int AnswerOn;
      // 1 if operating in *manual* speakerphone mode
//      int SpeakerPhoneOn;
      int AbortCommand;
//      int AllowAbortCommands;
      int StopTransmit;
      int Recording;
//      int OffHook;
//      int PortLocked;
//      int ClientConnected;
//      int ResponceRequested;
      int IgnoreDTMF;
//      int Exit;

      ModemStatus() {
//         AnswerOn = 0;
//         SpeakerPhoneOn = 0;
         AbortCommand = 0; 
//         AllowAbortCommands = 0;
         StopTransmit = 0;
         Recording = 0;
//         OffHook = 0;
//         PortLocked = 0;
//         ClientConnected = 0;
//         ResponceRequested = 0;
         IgnoreDTMF = 0;
//         Exit = 0;
      }
};

#define CHECK_ABORT if (MState.AbortCommand) return;
#define CHECK_ABORT_0 if (MState.AbortCommand) return 0;
#define ABORT_CLOSE if (MState.AbortCommand){close(sfp);return 0;}
#define CHECK_AB_FREE if (MState.AbortCommand) {RemoveLockFile(); return;}

extern ModemStatus MState;

