#include <netconf.h>
#include <translat.h>
#include "inetdconf.h"
#include "inetdconf.m"
#include "inetdconfedit.h"
#include <module_apis/servicectl_apidef.h>


/*
 * SERVICECTL_API
 */
class SERVICE_INETDCONF: public SERVICE {
public:
	SERVICE_INETDCONF( const char *_name,
			const char *_desc,
			int state);
	int control (SERVICE_OPER oper);
	int edit (void);
	const char *getconfstatus (void);
	const char *getrunstatus (void);
	void showstatus (void);
};

PUBLIC SERVICE_INETDCONF::SERVICE_INETDCONF(
	const char *_name,
	const char *_desc,
	int _state)
	: SERVICE (_name,_desc,_state,OWNER_INTERNAL)
{
//fprintf(stderr,"SERVICE_INETDCONF::SERVICE_INETDCONF: name=%s desc=%s state=%d\n", _name, _desc, _state);
}

PUBLIC int SERVICE_INETDCONF::edit( )
{
//fprintf(stderr,"SERVICE_INETDCONF::edit\n");
	INETDCONFLIST inetdconflist;
	inetdconflist.read();
	for ( int i=0; i<inetdconflist.getnb(); i++ ) {
		INETDCONF *inetdconf = inetdconflist.getitem( i );
		if ( name.cmp( inetdconf->service_name.get() ) == 0 ) {
			char pp_info[100];
			snprintf( pp_info, sizeof(pp_info), "%d/%s/%d", inetdconf->port, inetdconf->protocol.get(), inetdconf->inetdconf_line );
			if ( desc.cmp( pp_info ) == 0 ) {
				inetdconf->edit( &inetdconflist );
				break;
			}
		}
	}
//fprintf(stderr,"SERVICE_INETDCONF::edit OK\n");
	return( previous );
}

PUBLIC const char *SERVICE_INETDCONF::getconfstatus (void)
{
//fprintf(stderr,"SERVICE_INETDCONF::getconfstatus\n");
	return state == 0 ? MSG_U(I_SYSVENABLED,"Enabled")
			: MSG_U(I_SYSVDISABLED,"Disabled");                       
}

PUBLIC const char *SERVICE_INETDCONF::getrunstatus (void)
{
//fprintf(stderr,"SERVICE_INETDCONF::getrunstatus\n");
	return state == 0 ? MSG_U(I_RUNNING,"On demand") : "";
}

PUBLIC void SERVICE_INETDCONF::showstatus (void)
{
//fprintf(stderr,"SERVICE_INETDCONF::showstatus\n");
}

PUBLIC int SERVICE_INETDCONF::control (SERVICE_OPER oper)
{
//fprintf(stderr,"SERVICE_INETDCONF::control\n");
	int ret = -1;
	return ret;
}

static int inetdconf_collect (SERVICES &tb)
{
//fprintf(stderr,"inetdconf_collect\n");
	INETDCONFLIST inetdconflist;
	inetdconflist.read();
	for ( int i=0; i<inetdconflist.getnb(); i++ ) {
		INETDCONF *inetdconf = inetdconflist.getitem( i );
		char pp_info[100];
		snprintf( pp_info, sizeof(pp_info), "%d/%s/%d", inetdconf->port, inetdconf->protocol.get(), inetdconf->inetdconf_line );
		tb.add (new SERVICE_INETDCONF (inetdconf->service_name.get(),pp_info,inetdconf->enabled?0:1));
	}
	return( 1 );
}

void *inetdconf_api_get ()
{
//fprintf(stderr,"inetdconf_api_get\n");
	SERVICECTL_API *api = new SERVICECTL_API;
	api->collect = inetdconf_collect;
	return api;
}

void inetdconf_api_release (void *obj)
{
	SERVICECTL_API *api = (SERVICECTL_API*)obj;
	delete api;
}

