#include <dialog.h>
#include "dnsconf.h"
#include "dnsconf.m"
#include "internal.h"

static DNSCONF_HELP_FILE help_features ("features");
static DNSCONF_HELP_FILE help_access   ("access");

static const char K_DNSCONF[]="dnsconf";
static const char K_SYNCBASICHOST[]="syncbasichost";


/*
	Return true is linuxconf is allowed to update the DNS using the
	basic host information screen.
*/
bool features_getsyncbasichost()
{
	return linuxconf_getvalnum (K_DNSCONF,K_SYNCBASICHOST,1) != 0;
}


/*
	Set a list of records in a dialog.
	Add 3 extra empty fields at the end.
*/
void feature_editlist (
	DIALOG &dia,
	int level,
	const char *ftitle,
	SSTRINGS &tb)
{
	dia.newf_title (ftitle,level,"",ftitle);
	for (int i=0; i<3; i++) tb.add(new SSTRING);
	for (int i=0; i<tb.getnb(); i++){
		dia.newf_str ("",*tb.getitem(i));
	}
}

static void features_removeempty(DNS_OPTIONS &options)
{
	options.allowtrans.remove_empty();
	options.allowquery.remove_empty();
	options.listenon.remove_empty();
}


PUBLIC void DNS::editaccess()
{
	DIALOG dia;
	feature_editlist (dia,1,MSG_U(F_ALLOWTRANS,"Allow transfer to")
		,options.allowtrans);
	feature_editlist (dia,1,MSG_U(F_ALLOWQUERY,"Allow query from")
		,options.allowquery);
	feature_editlist (dia,1,MSG_U(F_LISTENON,"Listen on")
		,options.listenon);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_DNSACCESS,"General access control")
			,""
			,help_access
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			dia.restore();
			features_removeempty(options);
			break;
		}else{
			features_removeempty(options);
			write();
			break;
		}
	}
}

PUBLIC void DNS::editfeatures()
{
	DIALOG dia;
	char syncbasic = features_getsyncbasichost() ? 1 : 0;
	dia.newf_chk (MSG_U(F_SYNCBASIC,"Syncrhonise DNS"),syncbasic
		,MSG_U(I_SYNCBASIC,"from basic host information"));
	dia.newf_chk (MSG_U(F_FORWARDONLY,"Forward only"),options.forward_only
		,MSG_U(I_FORWARDONLY,"Let the forwarders resolve"));
	dia.newf_chk (MSG_U(F_NORECURSE,"No recursion"),options.no_recursion
		,MSG_U(I_NORECURSE,""));
	dia.newf_chk (MSG_U(F_NOFETCHGLUE,"No fetch glue"),options.no_fetch_glue
		,MSG_U(I_NOFETCHGLUE,""));
	if (!bind8){
		dia.newf_chk (MSG_U(F_QUERYLOG,"Log each query"),options.query_log
			,"");
	}
	dia.newf_chk (MSG_U(F_FAKEIQUERY,"Fake iquery"),options.fake_iquery,"");
	if (!bind8){
		dia.newf_str (MSG_U(F_XFERNETS,"Limit zone transfer to networks")
			,xfernets);
		dia.newf_str (MSG_U(F_BOGUSNS,"Don't use those servers"),bogusns);
		dia.newf_str (MSG_U(F_SEARCHLIST,"Search list"),searchlist);
	}
	if (bind8){
		dia.newf_chk (MSG_U(F_NOTIFY,"Notify"),options.notify
			,"");
	}
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_DNSFEATURES,"DNS features")
			,""
			,help_features
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			dia.restore();
			break;
		}else{
			if (options.forward_only && forwarders.getnb() == 0){
				xconf_notice (MSG_U(N_NOFORWARDER
					,"You have selected the option forward only\n"
					 "but there are no forwarders defined.\n"
					 "\n"
					 "Input accepted anyway"));
			}
			linuxconf_replace (K_DNSCONF,K_SYNCBASICHOST,syncbasic);
			linuxconf_save();
			write();
			break;
		}
	}
}


