#!/bin/sh
if [ $# != 1 ]; then
	echo
	echo This utility is intended to be called from the Makefile
	echo install_one_subdir.sh basedir
	echo
	echo Install the help files of one subdirectory of a language
	echo
elif [ ! -f ../../scripts/install_all_lang.sh ] ; then
	echo
	echo Must be called from a subdirectory holding some sgml file
	echo two levels below the help.files directory
	echo
else
	PWD=`pwd`
	PRJ=`basename $PWD`
	DIR=`dirname $PWD`
	DIR=`basename $DIR`
	LANG=$DIR
	if [ "$LANG" = "sources" ] ; then
		LANG=eng
	fi
	export HELPDIR=$1/help.$LANG/$PRJ
	rm -fr $HELPDIR
	mkdir -p $HELPDIR
	if [ "$PRJ" = "main" ] ; then
		make introweb_html
	fi
	NBHELP=`find . -name \*.help | wc -l`
	NBHTML=`find . -name \*.html | wc -l`
	if [ $NBHELP != 0 -a $NBHTML != 0 ] ; then
		echo "    " Installing "*.html and *.help" in $HELPDIR
		install -m 644 -o root -g root *.help *.html $HELPDIR
	elif [ $NBHELP != 0 ] ; then
		echo "    " Installing "*.help" in $HELPDIR
		install -m 644 -o root -g root *.help $HELPDIR
	elif [ $NBHTML != 0 ] ; then
		echo "    " Installing "*.html" in $HELPDIR
		install -m 644 -o root -g root *.html $HELPDIR
	else
		echo "    " Nothing to install
	fi
fi



