/*
   main.c : fbgetty loader 
   Part of fbgetty 
   Copyright (C) 1999 Yann DRONEAUD (lch@multimania.com). 

   fbgetty is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   fbgetty is distributed in the hope that it will be useful, but 
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

 */



/*
  CVS id: $Id: main.c,v 1.3 1999/07/15 19:10:13 lch Exp $
*/

#include "global.h"
#include "options.h"
#include "init.h"
#include "errors.h"
#include "vt.h"
#include "prompt.h"


#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>

int 
main (int argc, char *argv[])
{

#ifndef __GLIBC__

  program_invocation_name = argv[0];

  /* get program short name */
  if (strrchr (program_invocation_name, '/') != NULL)
    program_invocation_short_name = strrchr (program_invocation_name, '/') + 1;
  else
    program_invocation_short_name = program_invocation_name;

#endif

  openlog (program_invocation_short_name, LOG_CONS | LOG_PID , LOG_AUTH);

  fgoptions = (fbgetty_options_t *) malloc(sizeof(struct fbgetty_options_t));
  if (fgoptions == NULL)
    fatal_error("can't allocate memory to fbgetty config");

  memset(fgoptions, 0x00,sizeof (fbgetty_options_t));

#ifdef FB_GETTY_DEBUG
  error("fbgetty launched");
#endif

  /* parse option */
  parse_command_line(argc,argv);
 
  /* open tty */
  init();

  /* Get log name */
  do
    {
      get_login_name();
    }
  while ((fgoptions->login_name_valid != TRUE) && (fgoptions->login_name == NULL) && (strlen(fgoptions->login_name) <= 0));

  restore_default_vt_handling();

#ifdef USE_FRAME_BUFFER
  if (fgoptions->fb_device != NULL)
    close (fgoptions->fb_fd);  
#endif

  
  closelog();

  /* launch login process */
  if (execl (fgoptions->login_program, fgoptions->login_program , "--", fgoptions->login_name, NULL) == -1)
    {    
      openlog (program_invocation_short_name, LOG_CONS | LOG_PID , LOG_AUTH);
      fatal_error ("%s: can't exec %s: %m", fgoptions->tty_device, fgoptions->login_program );
    }

  return(EXIT_FAILURE);
}









