
#ifndef _filter_H
#define _filter_H

#include <regex.h>

#include <apt-pkg/cacheiterators.h>

class FilterList
{
      public:
	struct Node;
	enum FilterType
	{ PkgName, PkgShortDesc, PkgLongDesc };

      protected:
	 Node * Head;
	Node *Tail;

	long nodecount;

      public:
	enum FilterMode
	{ None = 0, Upright = 1, Inverted = 2 };

	// length of the list
	inline int Length()
	{
		return nodecount;
	};

	// Check whether a package matches an expression
	bool Match(pkgCache::PkgIterator, FilterMode);

	// List functions
	Node *Push(char *str, FilterType);
	void Pop();
	void Revoke(long Identifier);
	void Audit();

	// Application operators
	void RedoLists(void);
	bool SimulateApply();

	// UI Helper Fuction
	void Display();

	 FilterList();
	 virtual ~ FilterList()
	{
	};
};

struct FilterList::Node
{
	long FilterID;
	regex_t preg;
	char *String;

	FilterType type;

	long filtercount;

	struct FilterList::Node * next;
};

extern FilterList Filters;

void filter_add_single();
void filter_revoke_all();
void filter_display_all();
void filter_invert();

#endif
