
#ifndef _acquire_H
#define _acquire_H

#define Subwin_X(x) (x)
#define Subwin_Y(y) (y-1)

#define FUI_COLOR_BACK         COLOR_BLUE
#define FUI_COLOR_BORDER       COLOR_YELLOW
#define FUI_COLOR_DEFAULT      COLOR_WHITE

#include "acquire_status.h"
#include "captris.h"
#include "wrappers.h"

#include <apt-pkg/acquire.h>

class pkgRealAcquire;

class pkgAcquireInterface
{
      public:
	friend AcquireStatus;
	friend pkgRealAcquire;
	friend Captris;

	enum AcquireMaster
	{ UI, TI };

      protected:
	 AcquireMaster MasterType;

	pkgRealAcquire *pFetcher;
	AcquireStatus *pStat;

	bool NoCacheInit;
	bool WindowsActive;

	int itemized_len_y, itemized_len_x, itemized_pos_y, itemized_pos_x;
	int output_len_y, output_len_x, output_pos_y, output_pos_x;
	int total_len_y, total_len_x, total_pos_y, total_pos_x;
	int extra_len_y, extra_len_x, extra_pos_y, extra_pos_x;

	UniqueWindow *output, *itemized, *total, *extra;
	Captris *Game;

	void InitWindows();
	void DestroyWindows();
	void CalibrateWindows();
	void CleanUp();

	void Error(char *, ...);
	void ack_errors();
	void PrintOutputF(char *, ...);
	void Keywait();

	void StartCaptris();
	void StopCaptris();
	void ViewInstall();
	void ViewRemove();

      public:
	void AcquireUpdate();
	void AcquireRun();
	void AcquireUpgrade();

	 pkgAcquireInterface(AcquireMaster _Type = UI);
	~pkgAcquireInterface();
};

#include <apt-pkg/acquire.h>

class pkgRealAcquire:public pkgAcquire
{ pkgAcquireInterface *Fetcher;
	pkgAcquireStatus *Status;

      public:
	 virtual void SetFds(int &Fd, fd_set * RSet, fd_set * WSet);
	virtual void RunFds(fd_set * RSet, fd_set * WSet);

	 pkgRealAcquire::pkgRealAcquire(pkgAcquireStatus * _Status, pkgAcquireInterface * _Fetcher):pkgAcquire(_Status)
	{
		Fetcher = _Fetcher;
		Status = _Status;
	};
};


#endif // _acquire_H
