#if #cpu(powerpc)
/* PowerMac specific routines for dbootstrap */

#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>

/* The recursive workhorse for is_new_world().  Returns 1 */
/* if we find something in /proc/device-tree with an      */
/* interrupt-parent property, indicating new (3.x?) Open  */
/* Firmware.                                              */
int proc_recurse(const char *dirname)
{
  struct dirent *ent;
  int res = 0;
  DIR *dir;
  struct stat statbuf;
  
  dir = opendir(dirname);
  if(!dir) return 0;
  if(chdir(dirname) != 0) return 0;
  
  while((ent = readdir(dir))) {
    if(!strcmp(ent->d_name, "interrupt-parent"))
	res = 1;
    else if(strcmp(ent->d_name, ".") && strcmp(ent->d_name, "..")) {
      if(ent->d_type == DT_DIR) {
        res = proc_recurse(ent->d_name);
      } else if(lstat(ent->d_name, &statbuf) == 0
                && S_ISDIR(statbuf.st_mode)) {
        res = proc_recurse(ent->d_name);
      }
    }
    if(res == 1) {
      closedir(dir);
      return 1;
    }
  }
  closedir(dir);
  chdir("..");
  return 0;
}

/* If this returns 1, we are on a New-World Power Macintosh */
int is_new_world()
{
  int res;
  char *pwd;
  
  pwd = getcwd(NULL, 0); /* POSIX.1 extension - malloc it */
  if(!pwd) return 0;
  
  res = proc_recurse("/proc/device-tree");

  chdir(pwd);
  free(pwd);
  return res;
}

#endif
