// testscr.cc
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Tests the various screen-output mechanisms

#include "curses++.h"
#include "vscreen.h"
#include "vs_progress.h"
#include "vs_tree.h"
#include "pkg_tree.h"
#include "pkg_grouppolicy.h"
#include "apt.h"

#if 0

class simplescr:public vscreen
{
  vscreen *otherwin;
  const char *msg;

public:
  simplescr(const char *_msg):otherwin(NULL),msg(_msg) {}

  void dispatch_char(chtype ch)
  {
    if(global_bindings.key_matches(ch, "ExitScreen"))
      vscreen_exitmain();
    else if(global_bindings.key_matches(ch, "CycleScreen") && otherwin)
      vscreen_show(otherwin);
  }

  void repaint() {bkgd(0); clear(); mvaddstr(0,0,msg);}

  void set_otherwin(vscreen *_otherwin) {otherwin=_otherwin;}
};

class foo:public cwindow
{
public:
  foo():cwindow(11,10,10,10) {}
};

class simplenode:public vs_treeitem
{
  const char *title;

public:
  simplenode(const char *_title):title(_title) {}

  const char *tag() const {return title;}

  void display(vs_tree *win, int y)
    {
      int width,height;
      int basex=2*get_depth();
      win->getmaxyx(height,width);

      win->move(y,0);
      for(int i=0; i<basex && i<width; i++)
	win->addch(' ');

      if(basex>width)
	return;

      win->addnstr(title, width-basex);

      int newy,newx;
      win->getyx(newy,newx);

      for( ; newx<width; newx++)
	win->addch(' ');
    }

  void highlighted(vs_tree *win)
    {
      char buf[100];
      int width,height;
      win->getmaxyx(height,width);
      snprintf(buf, 100, "[width: %i, height: %i]  %s selected", width, height, title);
      win->set_status(buf);
    }

  void unhighlighted(vs_tree *win)
    {
      win->set_status("");
    }
};

class simplesubtree:public vs_subtree_generic
{
  const char *title;

public:
  simplesubtree(const char *_title, bool _expanded):vs_subtree_generic(_expanded),title(_title) {}

  const char *tag() const {return title;}

  void display(vs_tree *win, int y)
    {
      int width, height;
      int basex=2*get_depth();
      win->getmaxyx(height,width);

      win->move(y,0);
      for(int i=0; i<basex && i<width; i++)
	win->addch(' ');

      if(basex>width)
	return;

      win->addnstr(get_expanded()?"[+] ":"[-] ", width-basex);

      if(basex+4>width)
	return;

      win->addnstr(title, width-(basex+4));

      int newy,newx;
      win->getyx(newy,newx);

      for( ; newx<width; newx++)
	win->addch(' ');
    }

  void highlighted(vs_tree *win)
    {
      char buf[100];
      int width,height;
      win->getmaxyx(height,width);
      snprintf(buf, 100, "[width: %i, height: %i]  %s selected", width, height, title);
      win->set_status(buf);
    }

  void unhighlighted(vs_tree *win)
    {
      win->set_status("");
    }
};

class mytree:public vs_tree
{
  vscreen *otherwin;
public:
  mytree(simplesubtree *_root):vs_tree(_root),otherwin(NULL) {}

  void set_otherwin(vscreen *_otherwin) {otherwin=_otherwin;}

  void dispatch_char(chtype ch)
  {
    if(global_bindings.key_matches(ch, "CycleScreen") && otherwin)
      vscreen_show(otherwin);
    else if(global_bindings.key_matches(ch, "ExitScreen"))
      vscreen_exitmain();
    else
      vs_tree::dispatch_char(ch);
  }
};

#endif

class mypkgtree:public pkg_tree
{
  vscreen *otherwin;
public:
  void set_otherwin(vscreen *_otherwin) {otherwin=_otherwin;}

  void dispatch_char(chtype ch)
  {
    if(global_bindings.key_matches(ch, "CycleScreen") && otherwin)
      vscreen_show(otherwin);
    else if(global_bindings.key_matches(ch, "ExitScreen"))
      vscreen_exitmain();
    else
      pkg_tree::dispatch_char(ch);
  }

  void init_apt()
  {
    vs_progress progbar(this);
    add_status_widget(&progbar);
    apt_init(&progbar);
    remove_status_widget(&progbar);
  }

  void save_selections()
  {
    vs_progress progbar(this);
    add_status_widget(&progbar);
    (*apt_cache_file)->save_selection_list(progbar);
    remove_status_widget(&progbar);
  }
};

#if 0

void make_funkytree(simplesubtree *parent, int maxdepth, int num)
{
  char buf[100];
  int i=0;

  if(maxdepth==0)
    return;

  while(rand()%2)
    {
      if(rand()%2)
	{
	  snprintf(buf, 100, "Tree %i-%i",maxdepth, i++);
	  simplesubtree *newtree=new simplesubtree(strdup(buf), (rand()<RAND_MAX/2));
	  parent->add_child(newtree);
	  make_funkytree(newtree, maxdepth-1, 0);

	  assert(newtree->get_depth()==parent->get_depth()+1);
	}
      else
	{
	  snprintf(buf, 100, "Node %i-%i", maxdepth, i++);
	  simplenode *newnode=new simplenode(strdup(buf));
	  parent->add_child(newnode);
	  assert(newnode->get_depth()==parent->get_depth()+1);
	}
    }
}

void make_counttree(simplesubtree *parent, int depth, int num, int &start)
{
  char buf[100];
  if(depth==0)
    {
      for(int i=0; i<num; i++)
	{
	  snprintf(buf, 100, "Number %i", start++);
	  parent->add_child(new simplenode(strdup(buf)));
	}
    }
  else
    {
      for(int i=0; i<num; i++)
	{
	  snprintf(buf, 100, "Subgroup %i-%i", depth, start);
	  simplesubtree *newtree=new simplesubtree(strdup(buf),true);
	  parent->add_child(newtree);
	  make_counttree(newtree, depth-1, num, start);
	}
    }
}

#endif

int main(int argc, char *argv[])
{
  srandom(time(0));

  init_vscreen();

  /*  foo mywin;
      int x,y;
  cwindow statuswin(2,0,2,2);
  statuswin.scrollok(FALSE);

  mywin.mvaddstr(0,0,"Hello, curses!  This is a long message which should scroll off the right edge of the window!  Or maybe not, it seems now that it's scrolling down.  Heh.  Let's see what happens if a whole lot of stuff is output!  Whee! :)");
  mywin.getyx(y,x);
  statuswin.printw("Cursor at: (%i, %i)", x, y);
  mywin.noutrefresh();
  statuswin.noutrefresh();
  doupdate();

  mywin.getch();

  mywin.move(5,1);
  mywin.insdelln(-3);
  mywin.getyx(y,x);
  statuswin.clear();
  statuswin.move(0,0);
  statuswin.printw("Cursor at: (%i, %i)", x, y);
  mywin.refresh();
  statuswin.refresh();

  mywin.getch();

  mywin.delwin();
  statuswin.delwin();*/

#if 0

  char buf1[100],buf2[100];

  snprintf(buf1, 100, "First try for color: %i", get_color("test",COLOR_WHITE, COLOR_BLACK));
  snprintf(buf2, 100, "Second try for color: %i", get_color("test",COLOR_WHITE, COLOR_BLACK));

  simplescr screen1(buf1);
  simplescr screen2(buf2);

  simplenode *node1=new simplenode("Node 1");
  simplenode *node2=new simplenode("Node 2");
  simplenode *node3=new simplenode("Node 3");
  simplenode *node4=new simplenode("Node 4");
  simplenode *node5=new simplenode("Node 5");
  simplenode *node6=new simplenode("Node 6");
  simplenode *node7=new simplenode("Node 7");

  simplesubtree *roottree=new simplesubtree("Root Node",true);
  simplesubtree *tree1=new simplesubtree("Tree 1",false);
  simplesubtree *tree2=new simplesubtree("Tree 2",true);
  simplesubtree *tree3=new simplesubtree("Tree 3", false);
  simplesubtree *tree4=new simplesubtree("Tree 4", false);
  simplesubtree *randtree=new simplesubtree("Random items", true);
  simplesubtree *counttree=new simplesubtree("Counting items", true);

  roottree->add_child(tree1);
  roottree->add_child(randtree);
  roottree->add_child(counttree);
  roottree->add_child(node1);
  roottree->add_child(tree3);
  tree1->add_child(node2);
  tree1->add_child(tree2);
  tree2->add_child(tree4);
  tree2->add_child(node4);
  tree1->add_child(node3);
  tree3->add_child(node5);
  tree3->add_child(node6);
  tree4->add_child(node7);
  make_funkytree(randtree, 5, 0);

  int num=0;
  make_counttree(counttree, 3, 5, num);
  roottree->sort();

  roottree->set_depth(-1);

  mytree screen3(roottree);

#endif

  mypkgtree mainscreen;

#if 0

  screen1.set_otherwin(&screen2);
  screen2.set_otherwin(&screen3);
  screen3.set_otherwin(screen4);
  screen3.set_header("Virtual Screen Infrastructure Test");

#endif

  mainscreen.set_otherwin(&mainscreen);
  mainscreen.set_header("Aptitude " VERSION);

  vscreen_show(&mainscreen);

  mainscreen.init_apt();

  mainscreen.set_grouping(new pkg_grouppolicy_filter_factory(pkg_missing_filter,new pkg_grouppolicy_status_factory(new pkg_grouppolicy_section_factory(pkg_grouppolicy_section_factory::split_topdir,new pkg_grouppolicy_section_factory(pkg_grouppolicy_section_factory::split_subdir,new pkg_grouppolicy_end_factory())))));

  vscreen_mainloop();

  mainscreen.save_selections();

  endwin();

  return 0;
}
