// pkg_tree.h      -*-c++-*-
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Uses the vs_tree classes to display a tree containing packages.  A generic
// version of this, suitable only for displaying the current state of the
// package cache, is provided; it can be extended as needed.

//  Current state -- uses the generic tree class, just displays all the
// packages in a flat hierarchy (like console-apt, eww)

#ifndef PKG_TREE_H
#define PKG_TREE_H

#include "vs_tree.h"
#include <apt-pkg/progress.h>

class pkg_grouppolicy_factory;

class pkg_tree:public vs_tree
{
  pkg_grouppolicy_factory *grouping;

  void snarf_errs();
protected:
  void update_pkglist();
  void install_run();
public:
  pkg_tree(pkg_grouppolicy_factory *_grouping=NULL);

  virtual void dispatch_char(chtype ch);

  void build_tree();
  // [re]builds the tree using the current grouping strategy.
  // (also sorts it)

  void set_grouping(pkg_grouppolicy_factory *_grouping);

  void paint_header();

  ~pkg_tree();
};

#endif
