/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "prepmx.pas" */


#include "cfuncs.h"


#ifndef STRINGS_H

#endif

#ifndef GLOBALS_H
#include "globals.h"
#endif

#ifndef PREAMBLE_H
#include "preamble.h"
#endif

#ifndef LYRICS_H
#include "lyrics.h"
#endif

#ifndef MTX_H
#include "mtx.h"
#endif

#ifndef ANALYZE_H
#include "analyze.h"
#endif

#ifndef MTXLINE_H
#include "mtxline.h"
#endif

#ifndef STATUS_H
#include "status.h"
#endif

#ifndef UPTEXT_H
#include "uptext.h"
#endif

#ifndef FILES_H
#include "files.h"
#endif


/** M-Tx preprocessor to PMX     Dirk Laurie */

#define version         "0.52"
#define version_date    "<29 October 1998>"

/** To do next:
   If upper voice is alone on stave, don't use lyralter
{* Current improvements:
   .. shortcut
{* Current bugs:
{* Old bugs:
   Does not check PMX syntax
{* Weaknesses that may later cause bugs:
   Decisions sometimes made on note, sometimes on scan
   Can 'here' overrun?
   Where does one note stop and the next begin?
{* Undocumented features:
   Options -D and -p are for the convenience of the development team.
{* To do:
   Own calculation of height
   Triplets and their variations
*/

#define chord_flat      't'
#define chord_left      'l'
#define lyrics_adj      '@'

#define blind           true
#define visible         false


static boolean last_bar;
static char multibar[256];
static char repeat_sign[256];
static short bar_of_line, bars_of_rest, rest_spacing;


/* --------------- Bars and rests --------------- */

static void writeRepeat(char *bar)
{
  char repcode[256];
  char STR1[256];

  if (*bar == '\0')
    return;
  *repcode = '\0';
  if (!strcmp(bar, "||"))
    strcpy(repcode, "Rd");
  else if (!strcmp(bar, "|]"))
    strcpy(repcode, "RD");
  else if (!strcmp(bar, "|:"))
    strcpy(repcode, "Rl");
  else if (!strcmp(bar, ":|:"))
    strcpy(repcode, "Rlr");
  else if (!strcmp(bar, ":|"))
    strcpy(repcode, "Rr");
  else if (last_bar && !strcmp(bar, "|"))
    strcpy(repcode, "Rb");
  if (*repcode != '\0') {
    sprintf(STR1, " %s", repcode);
    putLine(STR1);
  }
  *bar = '\0';
}


static void supplyRests(voice_index voice)
{
  char STR2[4];
  char STR3[256];

  if (multi_bar_rest) {
    put(multibar, putspace);
    return;
  }
  if (bar_of_line == 1 && pedantic) {
    printf("Bar %d Voice %d", bar_no, voice);
    warning(" Filling missing voice with rests", !print);
  }
  if (pickup > 0)
    put(rests(STR3, pickup, meterdenom, visible), nospace);
  sprintf(STR2, "%s ", pause);
  put(STR2, putspace);
}


static void countBars(char *note_)
{
  char note[256];
  short k, adjust;
  short sign = 1;

  strcpy(note, note_);
  predelete(note, 2);
  k = pos1('+', note);
  if (k == 0) {
    k = pos1('-', note);
    if (k > 0)
      sign = -1;
  }
  if (k > 0) {
    note[k-1] = '/';
    getTwoNums(note, &bars_of_rest, &adjust);
  } else {
    getNum(note, &bars_of_rest);
    adjust = 0;
  }
  rest_spacing = adjust * sign + 14;
}


static void putMBRest(void)
{
  stave_index i, FORLIM;
  char STR1[256];
  char STR2[256], STR3[256];

  put("\\\\\\def\\atnextbar{\\znotes", nospace);
  FORLIM = nstaves;
  for (i = 1; i <= FORLIM; i++) {
    sprintf(STR3, "\\mbrest{%s}{%s}0",
	    toString(STR1, bars_of_rest), toString(STR2, rest_spacing));
    put(STR3, nospace);
    if (i < nstaves)
      put("|", nospace);
    else
      putLine("\\en}\\");
  }
  sprintf(STR3, "\\\\\\advance\\barno%s\\", toString(STR1, bars_of_rest - 1));
  putLine(STR3);
  bar_no += bars_of_rest - 1;
}


/* static variables for processLine: */
struct LOC_processLine {
  voice_index voice;
  char chords[256], note[256], pretex[256];
  short ngrace, nmulti;
  boolean last_was_tex, no_chords, no_uptext;
} ;

static void output(char *note_, struct LOC_processLine *LINK)
{
  char note[256];
  short notelen;
  char STR2[256];

  strcpy(note, note_);
  if (*note != '\0')
  {  /* pretex is saved up until a spacing note or rest comes */
    if (endsWith(note, "\\") && note[1] != '\\') {
      curtail(note, '\\');
      strcat(LINK->pretex, note);
      *note = '\0';
      return;
    }
    if (*LINK->pretex != '\0' && isNoteOrRest(note)) {
      sprintf(note, "%s\\ %s", LINK->pretex, strcpy(STR2, note));
      *LINK->pretex = '\0';
    }
    if (outlen > 0 && note[0] != ' ')
      sprintf(note, " %s", strcpy(STR2, note));
    notelen = strlen(note);
    if (outlen + notelen > PMXlinelength)
      LINK->last_was_tex = false;
    put(note, nospace);
  }
  if (thisNote(LINK->voice) == nextvoice)
    putLine("");
}

static void maybeDotted(char *note, struct LOC_processLine *LINK)
{
  if (strlen(note) < 2)
    return;
  if (note[1] == '"') {
    note[1] = note[0];
    strcat(LINK->pretex, "\\dotted");
  }
}

/* static variables for addChords: */
struct LOC_addChords {
  struct LOC_processLine *LINK;
  char nt[256];
} ;

static void outChord(struct LOC_addChords *LINK)
{
  renewChordPitch(LINK->LINK->voice, LINK->nt);
  sprintf(LINK->LINK->chords + strlen(LINK->LINK->chords), " z%s", LINK->nt);
  *LINK->nt = '\0';
}

static void addChords(struct LOC_processLine *LINK)
{
  struct LOC_addChords V;
  char w[256];
  short j = 1;
  short l, mus_line;
  paragraph_index0 chord_line;
  boolean arpeggio;
  char STR1[256];

  V.LINK = LINK;
  saveStatus(LINK->voice);
  *LINK->chords = '\0';
  chord_line = chordLineNo(LINK->voice);
  if (chord_line == 0)
    LINK->no_chords = true;
  if (LINK->no_chords)
    return;
  GetNextWord(w, P[chord_line-1], blank, dummy);
  sprintf(STR1, "%c", barsym);
  if (!strcmp(w, STR1) || *w == '\0')
    LINK->no_chords = true;
  sprintf(STR1, "%c", tilde);
  if (!strcmp(w, STR1) || LINK->no_chords)
    return;
  mus_line = line_no;
  line_no = orig_line_no[chord_line-1];
  arpeggio = (w[0] == '?');
  if (arpeggio) {
    strcpy(LINK->chords, " ?");
    predelete(w, 1);
  }
  if (w[0] < 'a' || w[0] > 'g') {
    sprintf(STR1, "%s: Chord word must start with note", w);
    error3(LINK->voice, STR1);
  }
  l = strlen(w);
  sprintf(V.nt, "%c", w[0]);
  for (j = 1; j <= l - 1; j++) {
    if (w[j] >= 'a' && w[j] <= 'g')
      outChord(&V);
    if (w[j] == chord_flat)
      w[j] = 'f';
    else if (w[j] == chord_left)
      w[j] = 'e';
    sprintf(V.nt + strlen(V.nt), "%c", w[j]);
  }
  if (*V.nt != '\0')
    outChord(&V);
  if (arpeggio)
    strcat(LINK->chords, " ?");
  strcat(LINK->note, LINK->chords);
  line_no = mus_line;
}

static char *processOther(char *Result, char *note_,
			 struct LOC_processLine *LINK)
{
  char note[256];

  strcpy(note, note_);
  switch (thisNote(LINK->voice)) {

  case other:
    if (note[0] == grace_group) {
      if (strlen(note) == 1)
	LINK->ngrace = 1;
      else
	LINK->ngrace = pos1(note[1], digits);
      if (LINK->ngrace > 0)
	LINK->ngrace--;
    }
    break;

  case lyrtag:
    extractLyrtag(LINK->voice, note);
    break;

  case rbrac:
    setUnbeamed(LINK->voice);
    break;

  case rparen:
  case rlparen:
    endSlur(LINK->voice, note);
    break;

  case lbrac:
    beginBeam(LINK->voice, note);
    break;

  case lparen:
    maybeDotted(note, LINK);
    beginSlur(LINK->voice, note);
    break;

  case mword:
    error3(LINK->voice, "Meter change must be the first word of its bar");
    break;

  case atword:
    lyricsAdjust(LINK->voice, note);
    break;
  }
  return strcpy(Result, note);
}

static void lookahead(struct LOC_processLine *LINK)
{
  char STR2[256];
  char STR3[256];

  clearBeamSlurEnd(LINK->voice);
  while (bind_left[(long)nextNote(LINK->voice)]) {
    switch (nextNote(LINK->voice)) {

    case rparen:
      incLastUnderSlur(LINK->voice);
      break;

    case rbrac:
      incLastUnderBeam(LINK->voice);
      break;
    }
    sprintf(LINK->note + strlen(LINK->note), " %s",
	    processOther(STR2, getMusicWord(STR3, LINK->voice), LINK));
  }
}

static void processNote(struct LOC_processLine *LINK)
{
  short l;
  boolean in_group = false;

  l = pos1(multi_group, LINK->note);
  if (l > 0)
    scan1(LINK->note, l + 1, &LINK->nmulti);
  activateBeamsAndSlurs(LINK->voice);
  if (LINK->ngrace > 0) {
    in_group = true;
    LINK->ngrace--;
  } else {
    if (LINK->nmulti > 0) {
      in_group = true;
      LINK->nmulti--;
    }
  }
  checkOctave(LINK->voice, LINK->note);
  renewPitch(LINK->voice, LINK->note);
  if (!in_group) {
    resetDuration(LINK->voice, LINK->note[1]);
    markDebeamed(LINK->voice, LINK->note);
  }
  lookahead(LINK);
  getSyllable(LINK->voice, LINK->pretex);
  if (endsWith(LINK->note, "s~") || endsWith(LINK->note, "t~"))
    shorten(LINK->note, strlen(LINK->note) - 3);
  addUptext(LINK->voice, &LINK->no_uptext, LINK->pretex);
  appendSlur(LINK->voice, LINK->note);
  addChords(LINK);
}


/* ---------------------------------------------------------------- */

static void processLine(voice_index voice_, short bar_no)
{
  struct LOC_processLine V;
  paragraph_index par_line;
  char STR1[256];

  V.voice = voice_;
  *V.pretex = '\0';
  V.last_was_tex = false;
  V.no_chords = false;
  V.no_uptext = false;
  par_line = musicLineNo(V.voice);
  V.nmulti = 0;
  V.ngrace = 0;
  line_no = orig_line_no[par_line-1];
  do {
    getMusicWord(V.note, V.voice);
    if (*V.note == '\0')
      return;
    switch (thisNote(V.voice)) {

    case rword:
      if (multi_bar_rest) {
	countBars(V.note);
	strcpy(V.note, multibar);
      } else {
	if (!no_uptext_for_rests)
	  addUptext(V.voice, &V.no_uptext, V.pretex);
	if (!isPause(V.note))
	  resetDuration(V.voice, V.note[1]);
      }
      break;

    case abcdefg:
      processNote(&V);
      break;

    case barword:
      if (V.voice == nvoices) {
	if (endOfBar(V.voice, bar_no))
	  strcpy(repeat_sign, V.note);
	else
	  writeRepeat(V.note);
      }
      sprintf(STR1, "%c", barsym);
      if (strcmp(V.note, STR1))
	*V.note = '\0';
      V.no_chords = false;
      break;

    case FirstOnly:
      if (V.voice != nvoices)
	*V.note = '\0';
      else
	strcpy(V.note, processOther(STR1, V.note, &V));
      break;

    default:
      strcpy(V.note, processOther(STR1, V.note, &V));
      break;
    }
    output(V.note, &V);
  } while (!endOfBar(V.voice, bar_no));
  if (!V.no_chords)
    skipChordBar(V.voice);
}


/* ------------------------------------------------------------------- */

static void getMeterChange(voice_index voice, char *new_meter)
{
  short pn1, pn2;
  char w[256], new_command[256];

  if (nextNote(voice) != mword)
    return;
  getMusicWord(w, voice);
  readMeter(w, &meternum, &meterdenom, &pn1, &pn2);
  full_bar = meternum * (64 / meterdenom);
  meterWord(new_command, meternum, meterdenom, pn1, pn2);
  if (*new_meter != '\0' && strcmp(new_meter, new_command))
    error3(voice, "The same meter change must appear in all voices");
  strcpy(new_meter, new_command);
}


#define all             100


/* static variables for musicParagraph: */
struct LOC_musicParagraph {
  char new_meter[256];
} ;

static void putPMXlines(struct LOC_musicParagraph *LINK)
{
  paragraph_index i, FORLIM;

  FORLIM = para_len;
  for (i = 0; i <= FORLIM - 1; i++) {
    if (startsWith(P[i], double_comment)) {
      predelete(P[i], 2);
      putLine(P[i]);
      strcpy(P[i], "%");
    }
  }
}

static void processOneBar(struct LOC_musicParagraph *LINK)
{
  paragraph_index0 m, cm;
  short n1, n2;
  voice_index voice, cvoice;
  boolean ignore_voice;
  boolean wrote_repeat = false;
  boolean alone;
  char STR2[256];
  char STR3[256];

  if (bar_of_line > 1) {
    sprintf(STR3, "%cBar %s", comment, toString(STR2, bar_no));
    putLine(STR3);
  }
  last_bar = (bar_of_line == nbars && final_paragraph);
  if (last_bar && !strcmp(repeat_sign, "|"))
    *repeat_sign = '\0';
  writeRepeat(repeat_sign);
  *LINK->new_meter = '\0';
  for (voice = nvoices; voice >= 1; voice--) {
    if (musicLineNo(voice) > 0) {
      gotoBar(voice, bar_of_line);
      getMeterChange(voice, LINK->new_meter);
    }
  }
  if (last_bar && *LINK->new_meter == '\0' && nleft > pickup && meternum > 0)
    meterChange(LINK->new_meter, nleft, 64, true);
  if (*LINK->new_meter != '\0')
    putLine(LINK->new_meter);
  if (multi_bar_rest) {
    n1 = meternum * 64;
    n2 = meterdenom;
    cancel(&n1, &n2, 1);
    rests(multibar, n1, n2, blind);
  }
  for (voice = nvoices; voice >= 1; voice--) {
    ignore_voice = false;
    cvoice = companion(voice);
    m = musicLineNo(voice);
    cm = musicLineNo(cvoice);
    alone = (voice == cvoice || m > 0 && cm == 0 ||
	     m == 0 && cm == 0 && voice < cvoice);
    if (m > 0)
      processLine(voice, bar_of_line);
    else if (alone)
      supplyRests(voice);
    else
      ignore_voice = true;
    if (last_bar && *repeat_sign != '\0' && !wrote_repeat) {
      writeRepeat(repeat_sign);
      wrote_repeat = true;
    }
    if (!ignore_voice) {
      if (alone || voicePos(voice) == 1)
	putLine(" /");
      else
	putLine(" //");
    }
  }
  if (multi_bar_rest)
    putMBRest();
  bar_no++;
  pickup = 0;
  putLine("");
}

static void putMeter(char *new_meter_word, struct LOC_musicParagraph *LINK)
{
  if (strcmp(new_meter_word, old_meter_word))
    putLine(new_meter_word);
  strcpy(old_meter_word, new_meter_word);
}


static void musicParagraph(void)
{
  struct LOC_musicParagraph V;
  voice_index0 j, nvoice;
  char lyrassign[256];
  char STR1[256];
  char STR2[256];
  char STR3[256], STR4[256], STR5[256];
  voice_index0 FORLIM;
  short FORLIM1;

  paragraphSetup(&nvoice);
  if (nvoice == 0) {
    nonMusic();
    return;
  }
  if (nvoice > nvoices) {
    if (nvoice == 0)
      error("No voices! Did you remember to to supply a Style?", !print);
    sprintf(STR4, "Paragraph has %s voices but Style allows only %s",
	    toString(STR1, nvoice), toString(STR2, nvoices));
    error(STR4, !print);
    return;
  }
  if (first_paragraph)
    includeStartString();
  if (pmx_preamble_done && (!final_paragraph || nvoice > 0)) {
    sprintf(STR5, "%c Paragraph %s line %s bar %s",
	    comment, toString(STR1, paragraph_no),
	    toString(STR2, orig_line_no[0]), toString(STR3, bar_no));
    putLine(STR5);
  }
  testParagraph();
  if (verbose > 0)
    describeParagraph();
  /* ---- Knowing the score, we can start setting music ---------------- */
  if (!pmx_preamble_done) {
    doPMXpreamble();
    sprintf(STR3, "%c Paragraph %s line %s bar ",
	    comment, toString(STR1, paragraph_no),
	    toString(STR2, orig_line_no[0]));
    put(STR3, putspace);
    if (pickup > 0)
      putLine("0");
    else
      putLine("1");
  }
  putPMXlines(&V);
  if (some_vocal && (nvoice > 0 || !final_paragraph)) {
    FORLIM = ninstr;
    for (j = 1; j <= FORLIM; j++) {
      assignLyrics(j, lyrassign);
      if (*lyrassign != '\0') {
	sprintf(STR2, "\\\\%s\\", lyrassign);
	putLine(STR2);
      }
    }
  }
  if (must_respace)
    respace();
  if (meternum == 0)
    putMeter(meterChange(STR2, beatsPerLine(), meterdenom, true), &V);
  if (nleft > 0)
    nbars++;
  if (nbars == 0 && multi_bar_rest)
    nbars = 1;
  FORLIM1 = nbars;
  for (bar_of_line = 1; bar_of_line <= FORLIM1; bar_of_line++)
    processOneBar(&V);
}

#undef all


/* ----------------------------------------------------------------------- */

static boolean no_commands_yet;


static void doMusic(void)
{
  char STR1[256], STR2[256];
  char STR4[256];

  first_paragraph = true;
  pmx_preamble_done = false;
  bar_no = 1;
  *repeat_sign = '\0';
  must_respace = false;
  do {
    final_paragraph = endOfInfile();
    if (para_len > 0 && !ignore_input && thisCase()) {
      if (no_commands_yet) {
	interpretCommands();
	if (verbose > 0)
	  showOptions();
	one_beat = 64 / meterdenom;
	full_bar = meternum * one_beat;
	if (some_vocal)
	  putLine("\\input musixlyr\\:\\enableauxlyrics");
	if (nvoices > standardPMXvoices) {
	  sprintf(STR4, "You have %s voices; standard PMX can only handle %s",
		  toString(STR1, nvoices), toString(STR2, standardPMXvoices));
	  warning(STR4, !print);
	}
	initMTX();
	initUptext();
	initStatus();
	initLyrics();
	no_commands_yet = false;
      }
      if (startsWithBracedWord(P[0]))
	lyricsParagraph();
      else {
	musicParagraph();
	first_paragraph = false;
	writeRepeat(repeat_sign);
      }
    }
    readParagraph(P, orig_line_no, &para_len);
  } while (!final_paragraph);
}


static boolean control_paragraph, no_report_errors;


static boolean isControlParagraph(char (*P)[256], paragraph_index para_len)
{
  paragraph_index0 commands = 0, labels = 0, voices = 0, guff = 0;
  paragraph_index0 i;
  char w[256];

/* p2c: prepmx.pas: Note: Eliminated unused assignment statement [338] */
  for (i = 0; i <= para_len - 1; i++) {
    if (!startsWith(P[i], "%")) {
      NextWord(w, P[i], ' ', ':');
      if (!endsWith(w, ":"))
	guff++;
      else if (strlen(w) < 3 || findVoice(w) > 0)
	voices++;
      else if (isCommand(w))
	commands++;
      else
	labels++;
    }
  }
  if (voices + guff > commands)
    return false;
  return true;
}


static void topOfPMXfile(void)
{
  char STR2[256];

  putLine("---");
  sprintf(STR2, "\\immediate\\write10{M-Tx %s (Music from TeXt) %s}",
	  this_version, this_version_date);
  putLine(STR2);
  putLine("\\let\\:=\\relax\\input musixtex\\:\\sepbarrules\\input pmx");
}


main(int argc, char *argv[])
{  /* ---- Main program ------------------------ */
  PASCAL_MAIN(argc, argv);
  strcpy(this_version, version);
  strcpy(this_version_date, version_date);
  printf("==> This is M-Tx %s (Music from TeXt) %s\n", version, version_date);
  OpenFiles();
  no_commands_yet = true;
  preambleDefaults();
  no_report_errors = false;
  topOfPMXfile();
  do {
    readParagraph(P, orig_line_no, &para_len);
    control_paragraph = isControlParagraph(P, para_len);
    if (control_paragraph) {
      augmentPreamble(no_report_errors);
      no_report_errors = true;
      if (endOfInfile())
	error("No music paragraphs!", !print);
    }
  } while (control_paragraph);
  doPreamble();
  doMusic();
  CloseFiles();
  printf("PrePMX done.  Now run PMX.\n");
  _Escape(0);
  exit(EXIT_SUCCESS);
}




/* End. */
