/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;
import com.kvisco.xsl.*;
import com.kvisco.util.QuickStack;
import org.w3c.dom.Node;

/**
 * A class that represents the XSL Last() function call
**/
public class LastFunctionCall extends FunctionCall {
    
    /**
     * Creates a new LastFunctionCall
    **/
    public LastFunctionCall() {
        super(Names.LAST_FN);
    } //-- LastFunctionCall
    
    /**
     * Evalutes this NodeSetFunctionCall using the given Node as
     * the context. This method will always return a NumberResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        
        QuickStack stack = ps.getNodeSetStack();
        NodeSet nodeSet = null;
        if (stack.empty()) {
            nodeSet = new NodeSet();
            nodeSet.add(context);
        }
        else nodeSet = (NodeSet)stack.peek();
        return new NumberResult((double)nodeSet.size());
    } //-- evaluate
    
} //-- LastFunctionCall