/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;
import com.kvisco.xsl.*;
import com.kvisco.util.QuickStack;
import com.kvisco.util.List;
import org.w3c.dom.Node;
public class GenerateIDFunctionCall extends FunctionCall {
    
    /**
     * Creates a new GenerateIDFunctionCall
    **/
    public GenerateIDFunctionCall() {
        super(Names.GENERATE_ID_FN);
    } //-- GenerateIDFunctionCall
    
    /**
     * Evalutes this FunctionCall using the given Node as
     * the context. This method will always return a NumberResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        
        List params = getParameterList();
        Node node = context;
        if (params.size() == 1) {
            Expr expr = (Expr)params.get(0);
            ExprResult exprResult = expr.evaluate(context, ps);
            if (exprResult.getResultType() == ExprResult.NODE_SET) {
                NodeSet nodeSet = (NodeSet)exprResult;
                if (nodeSet.size() == 0) {
                    return new StringResult("");
                }
                else node = nodeSet.get(0);
            }
            //-- need to add ErrResult
            else {
                StringBuffer errMsg 
                    = new StringBuffer("InvalidParameterType:");
                errMsg.append(" expecting NodeSet as parameter to: ");
                errMsg.append(this.toString());
                return new StringResult(errMsg.toString());
            }
        }
        return new StringResult( ps.generateId(node) );
    } //-- evaluate
    
} //-- GenerateIDFunctionCall