/*
 * Decompiled with CFR 0.152.
 */
package xslp.xml.parsers;

import com.kvisco.xml.parser.DOMPackage;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Locale;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import xslp.xml.parsers.SimpleCatalog;

public class ProjectXParser
implements DOMPackage,
ErrorHandler {
    private boolean validate = false;
    private PrintWriter errorWriter = null;
    private Parser parser = null;
    private XmlDocumentBuilder builder = null;

    public ProjectXParser() {
        this.initParser();
    }

    public Document createDocument() {
        return new XmlDocument();
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.errorWriter.println(this.message("error", sAXParseException));
        this.errorWriter.flush();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.errorWriter.println(this.message("fatal error", sAXParseException));
        this.errorWriter.flush();
    }

    private void initParser() {
        this.parser = this.validate ? new ValidatingParser() : new Parser();
        SimpleCatalog simpleCatalog = new SimpleCatalog(System.getProperty("xml.catalog"));
        this.parser.setEntityResolver((EntityResolver)simpleCatalog);
        this.parser.setErrorHandler((ErrorHandler)this);
        String[] stringArray = new String[]{System.getProperty("user.language"), "en"};
        try {
            Locale locale = this.parser.chooseLocale(stringArray);
            this.parser.setLocale(locale);
        }
        catch (Exception exception) {}
        this.builder = new XmlDocumentBuilder();
        this.builder.setParser((org.xml.sax.Parser)this.parser);
    }

    private String message(String string, SAXParseException sAXParseException) {
        String string2 = String.valueOf(string) + " reading xml document: " + sAXParseException.getSystemId() + " (" + sAXParseException.getLineNumber() + ", " + sAXParseException.getColumnNumber() + ")" + " - " + sAXParseException.getMessage();
        return string2;
    }

    public Document readDocument(Reader reader, String string, PrintWriter printWriter) {
        this.errorWriter = printWriter;
        XmlDocument xmlDocument = null;
        try {
            try {
                InputSource inputSource = Resolver.createInputSource((File)new File(string));
                this.parser.parse(inputSource);
                xmlDocument = this.builder.getDocument();
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {}
        return xmlDocument;
    }

    public void setDocumentType(Document document, String string) {
        ((XmlDocument)document).setSystemId(string);
    }

    public void setValidation(boolean bl) {
        if (this.validate == bl) {
            return;
        }
        this.validate = bl;
        this.initParser();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.errorWriter.println(this.message("warning", sAXParseException));
        this.errorWriter.flush();
    }
}

