/*
 *    Completion.java
 *    Copyright (C) 1999 Rodrigo Reyes (reyes@chez.com)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jde.util;

import java.lang.reflect.Modifier;

/**
 * This class provides completion facilities.
 *
 * @author Rodrigo Reyes (reyes@chez.com) 
 */

public class Completion
{
    private static void listClassInfo(Class c) 
    {
	System.out.println("(list ");

	
	java.lang.reflect.Field[] fields = c.getDeclaredFields();
	System.out.print("(list ");
	for (int index=0; index<fields.length; index++)
	    if ((fields[index].getModifiers()|Modifier.PUBLIC)!=0)
		System.out.print("\""+fields[index].getName()+"\" ");
	System.out.println(")");

	
	java.lang.reflect.Constructor[] constrs = c.getDeclaredConstructors();
	System.out.print("(list ");
	for (int index=0; index<constrs.length; index++)
	    {
		if ((constrs[index].getModifiers()|Modifier.PUBLIC)!=0)
		    {
			System.out.print("(list \"");
			System.out.print(constrs[index].getName()+"\" ");
			listClassArray(constrs[index].getParameterTypes());
			System.out.print(")");
		    }
	    }
	System.out.print(")");

	
	java.lang.reflect.Method[] methods = c.getDeclaredMethods();
	System.out.println("(list ");
	for (int index=0; index<methods.length; index++)
	    {
		if ((methods[index].getModifiers()|Modifier.PUBLIC)!=0)
		    {
			System.out.print("(list \"");
			System.out.print(methods[index].getName()+"\" \"");
			
			System.out.print(className(methods[index].getReturnType()) + "\" ");
			
			listClassArray(methods[index].getParameterTypes());
			System.out.print(")");
		    }
	    }
	System.out.println(")");
	
	System.out.println(")");
	return;
    }
	
    public static void getClassInfo(String className)
    {
	try {
	    
	    Class c = Class.forName(className);
	    if (c != null)
		listClassInfo(c);
	} catch (ClassNotFoundException cnfe) { }
    }

    /**
     * Looks up an unqualified class name in the class path to find possible
     * fully qualified matches.
     *
     * @param className a value of type 'String'
     */
    public static void getClassInfo(String className, String[]imports) 
    {
	//	System.out.println("length : " + imports.length);
	for (int i=0; i<imports.length; i++)
	    {
		String name = imports[i]+className;
		try {
		    Class c = Class.forName(name);
		    if (c != null)
			{
			    listClassInfo(c);
			}
		} catch (ClassNotFoundException cnfe) { }
		
 	    }
	System.out.println("nil");
    }

    static String className(Class c)
	{
	    if (c.isArray())
		return c.getComponentType().getName() + "[]";
	    else
		return c.getName();
	}
    
    static void listClassArray(Class[] classes)
    {
	//	System.out.println("(list ");
	for (int i=0; i<classes.length; i++)
	    {
		System.out.print("\"");
		System.out.print(className(classes[i]));
		System.out.print("\" ");
	    }
	//	System.out.println(")");
    }

} // Completion

// End of Completion.java
