#!/bin/sh
#
# src/unix/java/jre/jre.sh, a112, a112 97/06/30

unset ENV

# Set up default variable values if not supplied by the user.

#
# ibm.6832 ibm.7207
#

# Modified wrapper for Debian GNU/Linux
PRG=`type $0`
PRG=${PRG##* }
# If PRG is a symlink, trace it to the real home directory

while [ -L "$PRG" ]
do
    newprg=$(ls -l ${PRG})
    newprg=${newprg##*-> }
    [ ${newprg} = ${newprg#/} ] && newprg=${PRG%/*}/${newprg}
    PRG="$newprg"
done

PRG=${PRG%/*}
J_HOME=${PRG%/*}
progname=${0##*/}
ARCH=`arch`

if [ -z "$JAVA_HOME" ] ; then
    export JAVA_HOME
    JAVA_HOME=$J_HOME
fi

progname=${0##*/}
prog=$J_HOME/bin/linux/native_threads/${progname}

if [ -z "$JAVA_HOME" ] ; then
    export JAVA_HOME
    JAVA_HOME=$J_HOME
fi

#
# ibm.6591 - only set CLASSPATH if not already set
#
CLASSPATH="${CLASSPATH:-${DEFAULT_CLASSPATH}}"
if [ -z "${CLASSPATH}" ] ; then
    CLASSPATH="$JAVA_HOME/classes:$JAVA_HOME/lib/classes.jar:$JAVA_HOME/lib/rt.jar:$JAVA_HOME/lib/i18n.jar:$JAVA_HOME/lib/classes.zip"
else
    CLASSPATH="$CLASSPATH:$JAVA_HOME/classes:$JAVA_HOME/lib/classes.jar:$JAVA_HOME/lib/rt.jar:$JAVA_HOME/lib/i18n.jar:$JAVA_HOME/lib/classes.zip"
fi
export CLASSPATH

# Remove certain paths from LIBPATH, as they can cause library load problems.
# For security reasons, to load from current directory '.' must be explicitly specified.
#export LIBPATH
#LIBPATH=$J_HOME/lib/aix/native_threads`echo "${LD_LIBRARY_PATH}:${LIBPATH}"|\
#        awk -v RS=":" -v FS="[/ \n]*$" '$1!="/lib" && $1!="/usr/lib" &&
#          $1!="/usr/ccs/lib" && $1 != "" {printf ":%s",$1}'`
export LD_LIBRARY_PATH=$J_HOME/lib/linux/native_threads:$LD_LIBRARY_PATH

export THREADS_TYPE=native_threads
if [ -f $prog ]
then
    eval exec $DEBUG_PROG $prog $opts '"$@"'
else
    echo >&2 "$progname was not found in ${prog}"
    exit 1
fi
