// XXX The big query that is done takes a long time with SQLServer 6.5
// on a 200Mhz dual P6.  If you run it on a database server that can
// execute the query in < 5 seconds then this test is bogus.

import java.sql.*;


class TheTerminator extends Thread
{
   public void run()
   {
      try
      {
         sleep(3*60 * 1000);
         System.out.println("The query timeout didn't work.  " +
                            "Killing the test!");
         System.out.println("Failed t0005.");
         System.exit(1);
      }
      catch (java.lang.InterruptedException e)
      {
         System.out.println(e.getMessage());
      }
   }
}


/**
 * test the setQueryTimeout
 *
 */
public class t0005 extends Thread
{
   static Statement   stmt = null;
   static boolean     passed   = true;
   static ResultSet   rs = null;
   int                killDelay;

   public t0005(int killDelay_)
   {
      killDelay = killDelay_;
   }

   public void run()
   {
      try
      {
         sleep(killDelay);
         System.out.println("background thread is canceling");
         stmt.cancel();
      }
      catch(java.lang.InterruptedException e)
      {
         System.out.println("sleep was interrupted.  " + e.getMessage());
      }
      catch (SQLException e)
      {
         System.out.println("stmt.cancel failed.  " + e.getMessage());
      }
   }

   static private boolean doBigQuery()
   {
      int        count = 0;
      String     longQuery = 
         "select * from t0005 table1                                    " +
         "where table1.t1 in                                            " +
         "  (select t2 from t0005 table2                                " +
         "   where     table1.i < table2.i                              " +
         "      and table1.i in                                         " +
         "      (select table3.i                                        " +
         "              from t0005 table3                               " +
         "              where table2.s=table3.s                         " +
         "                    and table3.i in                           " +
         "                            (select i from t0005 table4       " +
         "                             where     table4.i < table2.i    " +
         "                                   and table4.t3 in           " +
         "                                  (select table5.t1           " +
         "                                   from t0005 table5          " +
         "                                   where table5.t2=table1.t1  " +
         "                                  )                           " +
         "                            )                                 " +
         "      )                                                       " +
         "  )                                                           " +
         " ";

      try
      {
         System.out.println("Performing big query");
         rs = stmt.executeQuery(longQuery);
      
         System.out.println("Results of big query are-");
         count = 0;
         while(rs.next())
         {
            int   n = rs.getInt("i");
            System.out.println("row is " + n);
            count++;
         }
         System.out.println(count + " rows were fetched\n");
         passed = false;
      }
      catch(SQLException e)
      {
         if (! (e.getMessage().equals("Query was canceled or timed out.")))
         {
            System.out.println("Exception in big query.\n" + e.getMessage());
            passed = false;
         }
         else
         {
            passed = true;
         }
      }
      return passed;
   }


   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      System.out.println("test the setQueryTimeout");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         count    = 0;
      Connection  cx       = Common.getConnection();


      stmt     = cx.createStatement();
      try
      {
         stmt.executeUpdate("drop table t0005");
      }
      catch (SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0005', because it does")))
         {
            throw e;
         }
      }
      
      count = stmt.executeUpdate("create table t0005              "
                                 + "  (i  integer      not null,       "
                                 + "   t1 datetime     not null,       "
                                 + "   s  varchar(20)  not null,       "
                                 + "   t2 datetime     not null,       "
                                 + "   t3 datetime     null)           ");
      System.out.println("Creating table affected " + count + " rows");
      
      PreparedStatement  pStmt = cx.prepareStatement(
         "insert into t0005 (i, s, t1, t2, t3)      " + 
         "    values (?, ?, ?, getdate(), getdate())");

      pStmt.setTimestamp(3, new Timestamp(98, 8, 9, 15, 35, 5, 0));
      
      final int rowsToAdd = 50;
      for(i=1; i<=rowsToAdd; i++)
      {
         pStmt.setInt(1, i);
         pStmt.setString(2, "row " + i);
         count += pStmt.executeUpdate();
      }
      
      System.out.println("Added " + count + " rows");

      stmt = cx.createStatement();
      for(i=1; i<=9; i++)
      {
         count = stmt.executeUpdate("insert into t0005                  " +
                                    "  (i, s, t1, t2, t3)               " + 
                                    "  select i+1, s, getdate(), t1, t3 " +
                                    "    from t0005");
         System.out.println("Added " + count + " rows");
      }


      //
      // Make sure this process dies no matter what.
      //
      TheTerminator terminator = new TheTerminator();
      terminator.start();
      sleep(100);

      System.out.println("Setting timeout to 5");
      stmt.setQueryTimeout(5);
      System.out.println("The timeout is " + stmt.getQueryTimeout());
            
      passed = passed && doBigQuery();

      rs = stmt.executeQuery("select * from t0005 where i=10");
      count = 0;
      System.out.println("Results of small query are-");
      while(rs.next())
      {
         int       n  = rs.getInt("i");
         String    s  = rs.getString("s");
         Timestamp t3 = rs.getTimestamp("t3");

         System.out.println("row - " + s + " " + t3);
         count++;
      }
      System.out.println(count + " rows were fetched");

      System.out.println("Setting timeout to 0");
      stmt.setQueryTimeout(0);
      System.out.println("The timeout is " + stmt.getQueryTimeout());


      final int millisecondsBeforeCancel = 3000;
      t0005   cancel = new t0005(millisecondsBeforeCancel);
      cancel.start();
      System.out.println("Starting query.  Will cancel in " +
                         millisecondsBeforeCancel + " milliseconds");
            
      passed = passed && doBigQuery();


      System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0005.\n");
      System.exit(passed ? 0 : 1);
   }
}

