/*
 *  WWW document access counter
 *
 *  RCS:
 *      $Revision: 2.3 $
 *      $Date: 1996/05/03 02:20:22 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *     main routine for WWW homepage access counter
 *  
 *  Input Parameters:
 *      type    identifier  description
 *
 *      N/A
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      N/A
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      None
 *
 *  Limitations and Comments:
 *      None
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   10-Apr-95   first cut
 *      muquit@semcor.com   06-07-95    release 1.2
 *      muquit@semcor.com   07-13-95    release 1.3
 *      ma_muquit@fccc.edu  10-11-97    release 2.3
 */

#define __Main__
#include "cdebug.h"
#include "combine.h"
#include "count.h"


#ifdef SYS_WIN32
#include "configNT.h"
#else
#include "config.h"
#endif


int main (argc, argv)
int
    argc;
char
    **argv;

{
    int
        i,
        rc=0,
        count,
        counter,
        counter_length,
        left_pad,
        ihas_referer=0,
        max_digits=MAX_DIGITS,
        display_what;

    unsigned int
        use_st=False,
        ignore_site=False;


    char
        hour[10],
        min[10],
        ampm[10],
        *dbuf=(char *) NULL,
        *browser_type,
        *remote_ip,
        *query_string,
        filename[MaxTextLength],
        tmpbuf[MaxTextLength],
        digitbuf[MaxTextLength];

    Sllist
        *llp;

    DigitInfo
        digit_info;

    FrameInfo
        frame_info;


/*
**---------initialize globals------Starts---
*/
    g_refhost=(Sllist *) NULL;
    g_ighost=(Sllist *) NULL;

    Grhost=0;
    Gsite=0;
    Gdebug=False;
    Gauto_file_creation=0;
    Gstrict_mode=1;
    GrgbMappingIsError=1;
/*
**---------initialize globals------Ends---
*/
    count=1;
    *hour='\0';
    *min='\0';
    *ampm='\0';
    *filename = '\0';
    *digitbuf='\0';
    *tmpbuf = '\0';
    counter = 0;
    left_pad=max_digits;
    use_st=False;
    display_what=SHOW_COUNTER;
    remote_ip=(char *) NULL;

    /*
    ** parse command line, this is only used for testing at commandline
    ** no command line flag is allowed in the web page while calling
    ** the program
    */

    for (i=1; i < argc; i++)
    {
        if (!strncmp(argv[i],"-debug",(int)strlen("-debug")))
        {
            Gdebug=True;
            break;
        }
    }

    Debug2("[%s] Count %s: --Debug--",GetTime(),Version);

    rc=CheckDirs();
    if (rc == 1)
    {
        *tmpbuf='\0';
        safeStrcpy(tmpbuf,"ConfigDir,DigitDir,DataDir,LogDir must differ",
                sizeof(tmpbuf)-1);
        Warning(tmpbuf);
        PrintHeader();
        StringImage(tmpbuf);
        exit(1);
    }

    /*
    ** parse the authorization list
    */
    ParseConfig ();

    /* print what we read, for debug only....... Remore asap */
    Debug2("---- g_refhost linked list -----",0,0);
    printList(g_refhost);
    Debug2("---- g_ighost linked list -----",0,0);
    printList(g_ighost);

    /*
    ** we will be only be here if everything is fine, otherwise we'll be
    ** out from ParseConfig()
    */


     Debug2("Gsite: %d",Gsite,0);
     Debug2("Gauto_file_creation= %d",Gauto_file_creation,0);
     Debug2("Gstrict_mode= %d",Gstrict_mode,0);

#ifdef ACCESS_AUTH
    /*
    ** check if the referer is a remote host or not. refere should
    ** be the local host.
    */
    ihas_referer=authRemhost();
    
    /* if not authorized, we won't be here */

#endif /* ACCESS_AUTH */
    /*
    ** get the user name from query string
    */
    query_string = (char *) getenv("QUERY_STRING");

    if (query_string == (char *) NULL)
    {
        *tmpbuf='\0';
        safeStrcpy(tmpbuf,"Empty QUERY_STRING",sizeof(tmpbuf)-1);
        Warning(tmpbuf);
        PrintHeader ();
        StringImage(tmpbuf);
        exit(1);
    }

    rc=ParseQueryString(query_string,&digit_info,&frame_info);
    if (rc)
    {
        Debug2("Error parsing QUERY_STIRNG",0,0);
        exit(0);
    }

    Debug2("\n",0,0);
    Debug2("Parsed QUERY_STRING",0,0); 
    Debug2(" ft=%d",frame_info.width,0);
    Debug4(" rgb=%d,%d,%d", frame_info.matte_color.red,
        frame_info.matte_color.green, frame_info.matte_color.blue,0);
    Debug2(" tr=%d",digit_info.alpha,0);
    Debug4(" trgb=%d,%d,%d",digit_info.alpha_red,
        digit_info.alpha_green,digit_info.alpha_blue,0);
    Debug2(" replace_color=%d",digit_info.replace_color,0);
    Debug4(" srgb=%d,%d,%d",
        digit_info.opaque_red,
        digit_info.opaque_green,
        digit_info.opaque_blue,
        0);
    Debug4(" prgb=%d,%d,%d",
        digit_info.pen_red,
        digit_info.pen_green,
        digit_info.pen_blue,
        0);
    Debug2(" maxdigits=%d",digit_info.maxdigits,0);
    Debug2(" wxh [ignored,exists for compatibity] =%dx%d", 
        digit_info.width, digit_info.height);
    Debug2(" md=%d", digit_info.maxdigits,0);
    Debug2(" pad=%d", digit_info.leftpad,0);
    Debug2(" ddhead=%s",digit_info.ddhead,0);
    Debug2(" st=%d",digit_info.st,0);
    Debug2(" sh=%d", digit_info.show,0);
    Debug2(" df=%s",digit_info.datafile,0);
    Debug2(" lit=%s",digit_info.literal,0);
    Debug2(" incr=%d",digit_info.increment_counter,0);
    Debug2(" negate=%d",digit_info.negate,0);
    Debug2(" rotate=%d",digit_info.rotate,0);
    Debug2(" degrees=%d",digit_info.rotate_degrees,0);
    Debug2(" timezone=%s",digit_info.time_z,0);
    Debug2(" timeformat=%d",digit_info.time_format,0);
    Debug2(" istrip=%d",digit_info.use_strip,0);
    Debug2(" image=%s", digit_info.gif_file,0);
    Debug2(" parsed QS--\n",0,0);


    if (digit_info.leftpad == True)
    {
        max_digits=digit_info.maxdigits;

        /* check for minimum max_digits */
        if (max_digits < 5)
            max_digits=5;
        if (max_digits > MAX_DIGITS)
            max_digits=MAX_DIGITS;
    }

    /*
    ** now find out what we'r trying to display
    */
    display_what=digit_info.display_type;

    if (display_what == SHOW_COUNTER)
    {
        if (checkfilename (digit_info.datafile) != 0)
        {
            *tmpbuf='\0';
            safeStrcpy(tmpbuf,"Illegal datafile path!",sizeof(tmpbuf)-1);
            Warning(tmpbuf);
            PrintHeader ();
            StringImage(tmpbuf);
            exit(1);
        }
    }
    /*
    ** get frameinfo
    */

    if (frame_info.width > 1)
        digit_info.Frame=True;
    else
        digit_info.Frame=False;
    /*
    ** get the IP address of the connected machine to check if we need
    ** to increment the counter
    */
    if (display_what == SHOW_COUNTER)
    {
        remote_ip = (char *) getenv("REMOTE_ADDR");
        if (remote_ip == (char *) NULL)
        {
            /*
            ** put a dummy here
            */
            remote_ip = "dummy_ip";
        }
        else
        {
            for (llp=g_ighost;llp;llp=llp->next)
            {
                ignore_site=CheckRemoteIP(remote_ip,llp->item);
                if (ignore_site == True)
                {
                    Debug2("Not counting IP: %s",remote_ip,0);
                    Debug2("ignored mask: %s",llp->item,0);
                }
            }

            /*
            for (i=0; i < Gsite; i++)
            {
                ignore_site=CheckRemoteIP(remote_ip,GignoreSite[i]);
                if (ignore_site == True)
                {
                    Debug2("Not counting IP: %s",remote_ip,0);
                    Debug2("GignoreSite[%d]:%s",i,GignoreSite[i]);
                    break;
                }
            }
            */
        }
    }

    /*
    ** initialize Limit array
    */


    if (display_what == SHOW_COUNTER)
    {
        Debug2("Maxdigits=%d",max_digits,0);
    }

#ifdef ACCESS_AUTH 
    if (Gstrict_mode == 1)
    {
        if (ihas_referer == 0)
        {
        /*
        ** no HTTP_REFERER env variable found.
        ** display a literal string. this will make sure that even if
        ** someone with a broken browser tries to access the counter
        ** remotely, will not mess up the datafile. of course we'll
        ** miss some counts. because anyone accesses the page with a 
        ** broken browser like this will see a literal string
        */
            (void) strcpy(digit_info.literal,"888888");
        /*
        if (remote_ip != (char *) NULL)
        {
            (void) sprintf(tmpbuf,"No HTTP_REFERER supplied from %s",
                remote_ip);
            Warning(tmpbuf);
        }
        */
        /*
        ** try to get the browser name, it will give us a good
        ** feedback.
        */
            browser_type=(char *) getenv("HTTP_USER_AGENT");
            if (browser_type != (char *) NULL)
            {
                if (remote_ip != (char *) NULL)
                {
                    *tmpbuf='\0';
                    /* some jerk might try to overflow buffer */
                    safeStrcpy(tmpbuf,browser_type,sizeof(tmpbuf)-1);
                    safeStrcpy(digitbuf,"browser without referer ",
                            sizeof(digitbuf)-1);
                    safeStrcat(digitbuf,tmpbuf,sizeof(digitbuf)-1);
                    Warning(digitbuf);
                    *digitbuf='\0';
                }
            }
        }
    }   /* Gstrict_mode == 1 */
#endif

    switch (display_what)
    {

        case SHOW_CLOCK: /* act as a clock*/
        {
            displayTime(&digit_info,&frame_info);
            /*
            ** we will not be here
            */
            exit(0);
            break;
        }

        case SHOW_DATE:
        {
            displayDate(&digit_info,&frame_info);
            /*
            ** we won't be here
            */
            break;
        }

        case SHOW_GIF_FILE:
        {
            if (*digit_info.gif_file == '\0')
            {
                PrintHeader();
                StringImage("No GIF file specified to dispaly");
                exit(1);
            }
            /*
            ** security fix. oct-10-1997
            ** first check if the image file specified with image=
            ** parameter has any path in it
            */
            if (checkfilename(digit_info.gif_file) != 0)
            {
                PrintHeader();
                StringImage("Illegal image filename!");
                exit(0);
            }

            /* 
            ** check if counter is needed to be incremented
            */

            if (*digit_info.datafile != '\0')
            {
                Debug2("datafile=\"%s\"",digit_info.datafile,0);
                /*
                ** check increment. if true, we'll make the path of the
                ** datafile. Note: we'll never display it, just increment
                */
                if (digit_info.increment_counter)
                {
                    Debug2("increment counter behind the image!",0,0);
                    /* check if some idiot is trying to screw up */
                    if (checkfilename(digit_info.datafile))
                    {
                        PrintHeader();
                        StringImage("Illegal character in filename!");
                        exit(0);
                    }
                    safeStrcpy(filename,DataDir,sizeof(filename)-1);
                    safeStrcat(filename,"/",sizeof(filename)-1);
                    safeStrcat(filename,digit_info.datafile,
                            sizeof(filename)-1);

                    Debug2("datafile path=%s",filename,0);
                    remote_ip = (char *) getenv("REMOTE_ADDR");
                    if (remote_ip)
                    {
                        for (llp=g_ighost;llp;llp=llp->next)
                            ignore_site=CheckRemoteIP(remote_ip,llp->item);
                    }
                    dbuf=rwCounterDataFile(filename,ignore_site,False,
                        1,digit_info.increment_counter);

                    if (dbuf)
                        (void) free(dbuf);
                }
            }

            /* make the gif filepath*/
            safeStrcpy(digitbuf,DigitDir,sizeof(digitbuf)-1);
            safeStrcat(digitbuf,"/",sizeof(digitbuf)-1);
            safeStrcat(digitbuf,digit_info.ddhead,sizeof(digitbuf)-1);
            safeStrcat(digitbuf,"/",sizeof(digitbuf)-1);
            safeStrcat(digitbuf,digit_info.gif_file,sizeof(digitbuf)-1);


            /*
            (void) sprintf(digitbuf,"%s/%s/%s",
                DigitDir,digit_info.ddhead,digit_info.gif_file);
            */
            WriteCounterImage(digitbuf,&digit_info,&frame_info);
            /*
            ** we won't be here
            */
            break;
        }
        case SHOW_COUNTER:
        default:
        {

            if (digit_info.comma == True)
                digit_info.leftpad=False;

            Debug2("digit_info.datafile=\"%s\"",digit_info.datafile,0);
            if ((int) strlen(digit_info.literal) > 0)
            {
                /* digitbuf buffer must be larger than MAX_DIGITS */
                   safeStrcpy(digitbuf,digit_info.literal,MAX_DIGITS-1);

                /* need to look at it again --------------------*/
                if (digit_info.comma == True)
                {
                    /* make sure all are digits, if not turn off comma */
                    for (i=0; i < strlen(digitbuf); i++)
                    {
                        if (!isdigit(digitbuf[i]))
                        {
                            Debug2("non digit in lit, turning off comma",0,0);
                            digit_info.comma=False;
                            break;
                        }
                    }
                }
                digit_info.leftpad=False;
                dbuf=mystrdup(digitbuf);
                if (dbuf == (char *) NULL)
                {
                    PrintHeader();
                    StringImage("memory allocation problem");
                    exit(0);
                 }
            }
            else if (mystrcasecmp(digit_info.datafile,DfForRandom) == 0)
            {
                srand(time(NULL));  /* Seed number generator */
                counter = rand();   /* My psychic prediction of counter value */

                /*
                ** we do not want to overflow buffer
                */
                Debug2("random number=%d",counter,0);

                *tmpbuf='\0';
                (void) sprintf(tmpbuf,"%d",counter);
                if (strlen(tmpbuf) > 10)
                    safeStrcpy(digitbuf,tmpbuf,10);
                else
                    safeStrcpy(digitbuf,tmpbuf,sizeof(digitbuf)-1);
              Debug2("random number after bound checning=%s",digitbuf,0);
              digit_info.leftpad=False;
              dbuf=mystrdup(digitbuf);
              if (dbuf == (char *) NULL)
              {
                  PrintHeader();
                  StringImage("memory allocation problem");
                  exit(0);
              }
            }
            else
            {
                safeStrcpy(filename, DataDir,sizeof(filename)-1);
                safeStrcat(filename, "/",sizeof(filename)-1);
                safeStrcat (filename,digit_info.datafile,sizeof(filename)-40);

                Debug2("datafile== %s",filename,0);

                /*
                ** check if the counter file exists or not
                */
                if (Gauto_file_creation == 0)
                {
                    if (CheckFile (filename) != 0)
                    {
                        if (strlen(filename) > sizeof(tmpbuf)-60)
                        {
                            PrintHeader();
                            StringImage("buffer overflow in filename");
                            exit(0);
                        }
                        *tmpbuf='\0';
                        (void) sprintf (tmpbuf,
                    "Counter datafile \"%s\" must be created first!", filename);
                        Warning(tmpbuf);
                        PrintHeader ();
                        StringImage (tmpbuf);
                        exit(1);
                    }

                }
                else
                {
                    if (CheckFile (filename) != 0)
                        use_st=True;
                }

                /*
                ** read-write the counter datafile
                */

                dbuf=rwCounterDataFile(filename,ignore_site,use_st,
                        digit_info.st,digit_info.increment_counter);
    
            }
    /* temporary things */

    Debug2("dbuf=%s",dbuf,0);

    if (dbuf != (char *) NULL)
    {
        safeStrcpy(digitbuf,dbuf,sizeof(digitbuf)-1);
        /* we don't need it anymore */
        (void) free(dbuf);
        dbuf=(char *) NULL;
    }
    else
    {
        PrintHeader();
        StringImage("unknown problem!");
        exit(0);
    }

    counter_length = (int) strlen(digitbuf);

        if (digit_info.show == False)
        {
            Image
                *image;

            image=CreateBaseImage(1,1,0,0,0,DirectClass);
            if (image == (Image *) NULL)
            {
                PrintHeader();
                StringImage("Failed to create 1x1 GIF image");
                exit(1);
            }

            AlphaImage(image,0,0,0);
            PrintHeader();
            (void) WriteGIFImage (image, (char *)NULL);
            DestroyAnyImageStruct (&image);
            exit(0);
        }

       if (digit_info.leftpad == False)    /* no left padding */
       {
           /*
            safeStrcpy(digitbuf,buf,sizeof(digitbuf)-1);
            */
            WriteCounterImage(digitbuf,&digit_info,&frame_info);
            /*
            ** we will not be here, we'll exit from LoadDigits()
            */
        }
        else
        {
            if (counter_length < max_digits)
                left_pad = max_digits - counter_length;
            else
                left_pad=0;

            Debug2(" MaxDigits=%d",max_digits,0);
            Debug2(" left_pad=%d",left_pad,0);

              if ((left_pad < max_digits) && (left_pad != 0))
              {

                if (left_pad > sizeof(tmpbuf)-1)
                {
                    PrintHeader();
                    StringImage("buffer overflow detected in left_pad");
                    exit(0);
                }
                (void) strcpy(tmpbuf,"0");
                for (i=1; i < left_pad; i++)
                {
                    (void) sprintf(tmpbuf,"%s0",tmpbuf);
                }
                (void) sprintf(tmpbuf,"%s%s",tmpbuf,digitbuf);
                WriteCounterImage(tmpbuf,&digit_info,&frame_info);
                /*
                ** we will not be here
                */
              }
              else    /* MaxDigits*/
              {
                  Debug2(" We are in MaxDigits=%d",max_digits,0);
                  WriteCounterImage(digitbuf,&digit_info,&frame_info);
                /*
                ** we won't be here
                */
               }

            }
            exit(0);
        } /* case SHOW_COUNTER*/
    }

    exit(0);
}
