/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                    Copyright (c) 1994,1995,1996                       */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                       Author:  Paul Taylor                            */
/*                       Date  :  April 1994                             */
/*-----------------------------------------------------------------------*/
/*                       EST_Track I/O header file                           */
/*                                                                       */
/*=======================================================================*/
#ifndef __TRACK_IO_H__
#define __TRACK_IO_H__

#include "EST_String.h"
#include "EST_rw_status.h"

EST_read_status load_xmg(const EST_String name, EST_Track &tr);
EST_read_status load_esps(const EST_String name, EST_Track &tr);
EST_read_status load_snns(const EST_String name, EST_Track &tr, float ishif);
EST_read_status load_ascii(const EST_String name, EST_Track &tr, float ishift);
EST_read_status load_xgraph(const EST_String name, EST_Track &tr);
EST_read_status load_htk(const EST_String name, EST_Track &tr);

// Note that these do not use a EST_Track reference argument because these
// functions change the track.
EST_write_status save_esps(const EST_String filename, EST_Track tr);
EST_write_status save_ascii(const EST_String filename, EST_Track tr);
EST_write_status save_xgraph(const EST_String filename, EST_Track tr);
EST_write_status save_xmg(const EST_String filename, EST_Track tr);
EST_write_status save_htk(const EST_String filename, EST_Track tr);

int track_to_espsf0(EST_Track &track, EST_Track &fz);
int espsf0_to_track(EST_Track &fz);

int track_to_htk_lpc(EST_Track &track, EST_Track &lpc);

extern "C" {
EST_write_status put_esps(const char *filename, const char *style, float *t, float *a, 
     int *v, float fsize, float rate, int num_points);

enum EST_write_status put_track_esps(const char *filename, char **f_names, 
				     float **a, float fsize, float rate, 
				     int order, int num_points);

EST_read_status get_esps(const char *filename, const char *style, 
	     float **t, float **a, int **v, float *fsize, int *num_points);

EST_read_status get_track_esps(const char *filename, char ***fields, float
		 ***a, float *fsize, int *num_points, int
		 *num_fields);
}

#endif /* __TRACK_IO_H__ */
