/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                       Author :  Paul Taylor                           */
/*                       Date   :  July 1996                             */
/*-----------------------------------------------------------------------*/
/*                   Type defines for Common Types                       */
/*                                                                       */
/*=======================================================================*/

#ifndef __EST_TYPES_H__
#define __EST_TYPES_H__

#include "EST_TList.h"
#include "EST_TVector.h"
#include "EST_String.h"
#include "EST_KV.h"

typedef EST_TVector<EST_String> EST_StrVector;
typedef EST_TVector<int> EST_IVector;
// DVector is an inherited TVector
// FVector is an inherited TVector

typedef EST_TList<int> EST_IList;
typedef EST_TList<float> EST_FList;
typedef EST_TList<EST_String> EST_StrList;
typedef EST_TList<double> EST_DList;

typedef EST_TList<EST_TList<int> > EST_IListList;
typedef EST_TList<EST_TList<int> > EST_StrListList;

typedef KVL<EST_String, EST_String> EST_StrStr_KVL;
typedef KVL<EST_String, int> EST_StrI_KVL;
typedef KVL<EST_String, float> EST_StrF_KVL;
typedef KVL<EST_String, double> EST_StrD_KVL;
//typedef KVL<EST_String, EST_Val> EST_StrVal_KVL;

typedef KVL<int, int> EST_II_KVL;


#endif // __EST_TYPES_H__
