/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, and modify this software and its            */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                  Author:  Paul Taylor                                 */
/*                  Date:    April 1994 -                                */
/*-----------------------------------------------------------------------*/
/*                     PDA include file                                  */
/*                                                                       */
/*=======================================================================*/
#ifndef __PDA_H__
#define __PDA_H__

#include "EST.h"

EST_Track pda(EST_Wave &sig, EST_Option &op, EST_String method = "");
EST_Track icda(EST_Wave &sig, EST_Track &speech, EST_Option &op, EST_String method = "");

void default_pda_options(EST_Option &al);

EST_Track do_srpd_fz(EST_Wave &sig);
EST_Track do_srpd_fz(EST_Wave &sig, EST_Option &options);

void low_pass_filter(EST_Wave &sig, int cutoff, int order);

EST_Track smooth_phrase(EST_Track &c, EST_Track speech, EST_Option &options);

void smooth_portion(EST_Track &c, EST_Option &op);

EST_Track int_contour(EST_Wave &sig, EST_Option &op);

#endif // __PDA_H__
