/*
 * MP3Info by Thorvald Natvig.
 * Read 'README' and the manpage for details.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include "mp3info.h"

#define NUMFORMATS 4

char *formats[NUMFORMATS]= {
   "%IT%It%t%!a, %IE%IE%Ia(%a), %IE%IE%b kbit/s %M %ICCRC %IE%(%mm %ss%)",
   "%t|%a|%l|%y|%c|%g|%#|%v|%L|%C|%b|%F|%M|%O|%o|%m|%s|%S|%f|%i",
   "%IT%ItTitle  : %t%N%IE%IaArtist : %a%N%IE%IlAlbum  : %l%N%IE%IyYear   : %y%N%IE%IcComment: %c%N%IE%IEFormat : %V Layer %L%N%ICFlags  : %ICCRC%IO %IE%IE%IOOriginal%IE%N%!E%IOFlags  : %ICCRC%IO %IE%IE%IOOriginal%IE%%N%IE%IEBitrate: %b Kbit/s %M%NLength : %mm %ss%NSize   : %i bytes",
   "%IT%It%t%!EUnknown title%IE by %Ia%a%!Eunkown artist%IE%Il from %l%IE%Iy in %y%IE%Ic (%c)%IE%IE"
};

void printhelp() {
   printf("MP3Info v%i.%i.%i by Thorvald Natvig\n\n",MAJVER,MINVER,PATCHVER);
   printf("Usage: mp3info [options] <filenames>\n\n");
   printf("See manpage for option details.\n");
}

int main (int argc,char *argv[])
{
   Mpfile *file=NULL;
   FILE *rcfile;
   size_t rcsize;
   Tag *newinfo;
   int  opt;
   int  shall_gettag=1, shall_std=1, shall_write=0;
   int  shall_wipe=0, shall_rename=0;
   int  shall_play=0, shall_random=0;
   char format[FORMAT_LEN+1];
   char rename[FORMAT_LEN+1];
   char output[STD_BUF_LEN];
   int  errorno=0;
   int  fileno,num;
   int  *randlist=NULL;
   int  numrands=0; 
   int  threads=0;
   int  formatnum;

   newinfo=new Tag;
   
   strcpy(format,formats[0]);

   if (getenv("HOME")) {
     strcpy(output,getenv("HOME"));
     strcat(output,"/.mp3info.rc");
     rcfile=fopen(output, "r");
     if (rcfile) {
       rcsize=fread(format, 1, FORMAT_LEN, rcfile);
       format[rcsize]=0;
       fclose(rcfile);
     }
   }   
   
   while ((opt=getopt(argc,argv,"Ts:f:F:wWn:t:a:l:y:c:g:G:p::N:P::R"))!=-1) {
      switch(opt) {
       case 'T' :
	 shall_gettag = 0;
	 break ;
       case 's' :
	 shall_std = strtol(optarg,NULL,10);
	 break;
       case 'f' :
	 if (strlen(optarg)>=FORMAT_LEN) fprintf(stderr,"Warning: Format is too long, cut.\n");
	 strncpy(format,optarg,FORMAT_LEN);
	 shall_std = 1;
	 break;
       case 'F' :
         formatnum=atoi(optarg);
         if ((formatnum<0) || (formatnum>=NUMFORMATS))
           fprintf(stderr,"Warning: Format number out of range, ignored.\n");
         else
           strcpy(format,formats[formatnum]);
         break;
       case 'w' :
	 shall_write = 1;
	 break;
       case 'W' :
	 shall_wipe = 1;
	 shall_std = 0;
	 break;
       case 'n' :
         fprintf(stderr,"Warning: Use -t instead of -n.\n");
	 strncpy(newinfo->title,optarg,30);
	 shall_write = 1;
	 break;
       case 't' :
	 strncpy(newinfo->title,optarg,30);
	 shall_write = 1;
	 break;
       case 'a' :
	 strncpy(newinfo->artist,optarg,30);
	 shall_write = 1;
	 break;
       case 'l' :
	 strncpy(newinfo->album,optarg,30);
	 shall_write = 1;
	 break;
       case 'y' :
	 strncpy(newinfo->year,optarg,4);
	 shall_write = 1;
	 break;
       case 'c' :
	 strncpy(newinfo->comment,optarg,30);
	 shall_write = 1;
	 break;
       case 'g' :
	 newinfo->gennum=strtol(optarg,NULL,10);
	 shall_write = 1;
	 break;
       case 'p' :
         newinfo->printgenres((optarg) ? atoi(optarg) : 0);
         return(0);
       case 'N' :
	 if (strlen(optarg)>=FORMAT_LEN) fprintf(stderr,"Warning: Format is too long, cut.\n");
	 strncpy(rename,optarg,FORMAT_LEN);
	 shall_rename = 1;
	 break;
       case 'P' :
#ifdef PLAYER
         shall_play = 1;
         if (optarg) threads=atoi(optarg);
#else
	 fprintf(stderr,"Warning: No player compiled, not playing.\n");
#endif
         break;
       case 'R' :
         shall_random = 1;
         break;
       default :
	 fprintf(stderr,"Sorry, option not implemented yet.\n");
      }
   }
   
   if (shall_wipe) {
      shall_write = 0;
      shall_gettag = 0;
   }
   
   if (optind==argc) {
      printhelp();
      return(0);
   }


   if (shall_random) {
     numrands=argc-optind;
     randlist=(int *)malloc((numrands+1)*sizeof(int));
     for (opt=0;opt!=numrands;opt++) {
       randlist[opt]=opt+optind;
     }
     srandom(time(NULL));
   }

   for (opt=optind;opt!=argc;opt++) {

      if (!shall_random)
        fileno=opt;
      else {
        num=random() % numrands;
        fileno=randlist[num];
        memmove(&randlist[num],&randlist[num+1],(numrands-num)*sizeof(int));
        numrands--;
      }
        

      file=new Mpfile;
      
      if (!(file->open(argv[fileno],(shall_write || shall_wipe)))) {
	 fprintf(stderr,"Error: Could not open file %s.\n",argv[fileno]);
         errorno=1;
      } else if (!(file->initfile(shall_gettag))) {
	 fprintf(stderr,"Error: no SYNC in file %s.\n",argv[fileno]);
         errorno=2;
      } else {
	 if (shall_write) {
            file->tag->copy(newinfo);
	    if (!file->writetag()) {
	       fprintf(stderr,"Error: Writing TAG failed on file %s.\n",argv[fileno]);
	       errorno=3;
	    }
	 }
	 
	 if (shall_wipe)
           if (!file->wipetag()) {
	     fprintf(stderr,"Error: Wiping TAG failed on file %s.\n",argv[fileno]);
	     errorno=4;
	 }
	 
	 if (shall_std) {
           if (file->mpformat(output,format,STD_BUF_LEN))
             printf("%s\n",output);
         }

	 if (shall_rename) {
	    if (!file->frename(rename)) {
	       fprintf(stderr,"Error: Renaming %s failed.\n",argv[fileno]);
	       errorno=5;
	    }
	 }
#ifdef PLAYER
	 if (shall_play) file->play(threads);
#endif
      }
      delete(file); 
   }
   return(errorno);
}
