/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** sRefTable.h
**
** based on sRefSet.h
*/

# ifndef sRefTABLE_H
# define sRefTABLE_H

typedef /*@owned@*/ sRef ow_sRef;

abst_typedef /*@null@*/ struct _sRefTable
{
  int entries;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ ow_sRef *elements;
} *sRefTable;

/*@constant int sRefTableBASESIZE; @*/
# define sRefTableBASESIZE HUGEBASESIZE

/*@constant null sRefTable sRefTable_undefined; @*/
# define sRefTable_undefined ((sRefTable) NULL)

extern /*@truenull@*/ bool sRefTable_isNull (sRefTable p_s) /*@*/ ;
extern /*@truenull@*/ bool sRefTable_isEmpty (/*@sef@*/ sRefTable p_s) /*@*/ ;
extern /*@unused@*/ /*@falsenull@*/ bool 
  sRefTable_isDefined (sRefTable p_s) /*@*/ ;

# define sRefTable_isNull(s) ((s) == sRefTable_undefined)
# define sRefTable_isDefined(s) ((!sRefTable_isNull(s)))

# define sRefTable_isEmpty(s) ((s) == sRefTable_undefined || ((s)->entries == 0))

extern /*@unused@*/ /*@only@*/ cstring sRefTable_unparse (sRefTable p_s) /*@*/ ;
extern void sRefTable_free (/*@only@*/ sRefTable p_s) /*@modifies p_s@*/;
extern void sRefTable_clear (sRefTable p_s) /*@modifies p_s@*/ ;
extern sRefTable 
  sRefTable_add (/*@returned@*/ sRefTable p_s, 
		 /*@special@*/ /*@owned@*/ sRef p_el)
  /*@modifies p_s@*/ ;

# else
# error "Multiple include"
# endif



