package biss.awt;


/**
 * interface for objects which know how to draw themselves (e.g. inside
 * of Lists). By using collections of SelfDrawingObjects, you don't have
 * to implement View specific draw methods to get sophisticated graphical
 * representations of your model data. It really is as easy as passing
 * Strings to the List (all drawing stuff is negotiated between the List
 * and the SelfDrawingObjects automagically).
 *
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public interface SelfDrawingObject
{
public int  	drawHeight ();

public void 	drawSelfIn ( Object pane );

public String	label ();

public int  	maxDrawWidth ();

}
