package biss.awt;

import biss.Command;
import biss.ObserverSocket;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.ImageObserver;
import java.util.Observable;
import java.util.Observer;

/**
 * abstract base used to implement various low level widgets
 * (java.awt.Canvas replacement)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Control
  extends Canvas
  implements Observer, FocusInterface, MouseInterface, KbdInterface, CmdInterface
{
	protected Rectangle DrawRect = new Rectangle(0,0,0,0);
	protected Component PeerTarget = null;
/**
 * externally triggered by the GUIHandler to notify about a
 * Menu or HotKey action
 * parameter: HotKey or MenuItem selector
 */
	public ObserverSocket OsCommand = new ObserverSocket( this, "Command");
/**
 * externally triggered by the GUIHandler to notify
 * that the Control got the input focus
 * parameter: -
 */
	public ObserverSocket OsFocusGot = new ObserverSocket( this);
/**
 * externally triggered by the GUIHandler to notify
 * that the Control lost the input focus
 * parameter: -
 */
	public ObserverSocket OsFocusLost = new ObserverSocket( this);
/**
 * externally triggered by the GUIHandler to notify
 * that the mouse pointer enters the Control area
 * parameter: -
 */
	public ObserverSocket OsMouseEnter = new ObserverSocket( this);
/**
 * externally triggered by the GUIHandler to notify
 * that the mouse pointer exits the Control area
 * parameter: -
 */
	public ObserverSocket OsMouseExit = new ObserverSocket( this);
/**
 * externally triggered by the GUIHandler to notify
 * about a MouseButton Event
 * parameter: Event
 */
	public ObserverSocket OsMouseBtn = new ObserverSocket( this);
	protected GUIHandler EventHandler = new GUIHandler( this);
	protected Border FBorder = new Border();
	protected int Width = 0;
	protected int Height = 0;
	protected int XPos = 0;
	protected int YPos = 0;
	PaintCmd RetainPainter = (Awt.FilterPaints > 0) ? new PaintCmd( this)  : null;

public boolean addHotKey( int c, int mods, HotKeyProcessor p, Object sel){
	return EventHandler.addHotKey( c, mods, p, sel);
}

public boolean addHotKey ( int c, int mods, Object sel ) {
	return EventHandler.addHotKey( c, mods, null, sel);
}

public synchronized void addNotify () {
	super.addNotify();

	Frame fr = getFrame();
	EventHandler.Fr = fr;
	if ( fr instanceof TopWindow)
		EventHandler.Super = ((TopWindow)fr).EventHandler;
}

public void blank(){
	Graphics g = getGraphics();
	if ( g != null ) {
		blank( g);
		g.dispose();
	}
}

public void blank( Graphics g){
	g.setColor( getBackground() );
	g.fillRect( DrawRect.x, DrawRect.y, DrawRect.width, DrawRect.height);
}

public boolean canGetFocus () {
	return isEnabled() && isShowing();
}

public void charInput( char c, int mod) {}

protected void clip( Graphics g){
	g.clipRect( DrawRect.x, DrawRect.y, DrawRect.width, DrawRect.height);
}

public synchronized void disable(){
	enable( false);
}

public void dispose () {
	//java.awt.peer.Component interface
	getPeer().dispose();
}

public synchronized void enable(){
	enable( true);
}

public void enable( boolean cond){
	Frame fr;

	EventHandler.IsDisabled = !cond;

	if ( isShowing() ){
		if ( (fr = getFrame()) instanceof TopWindow ) {
			if ( ((TopWindow)fr).Overlay == null ) { // otherwise Overlay has focus
				fr.requestFocus();  // don't break tab switching
				redraw();
			}
		}
		else
			redraw();
	}
}

public Rectangle getDrawRect(){
	return DrawRect;
}

public GUIHandler getEventHandler () {
	return EventHandler;
}

public Frame getFrame() {
	Container so = PeerTarget != null ? PeerTarget.getParent() : getParent();
	for ( ; so != null; so =so.getParent() ) {
		if ( so instanceof Frame)
			return (Frame)so;
	}
	return null;
}

public int getHeight(){
	return Height;
}

public Menu getMenu(){
	Menu m = new Menu( EventHandler.MenuCont);
	m.setHandler( EventHandler);
	return m;
}

public ObserverSocket getOsCommand() {
	return OsCommand;
}

public ObserverSocket getOsFocusGot() {
	return OsFocusGot;
}

public ObserverSocket getOsFocusLost() {
	return OsFocusLost;
}

public ObserverSocket getOsMouseBtn() {
	return OsMouseBtn;
}

public ObserverSocket getOsMouseEnter() {
	return OsMouseEnter;
}

public ObserverSocket getOsMouseExit() {
	return OsMouseExit;
}

public Container getParent(){
	if ( PeerTarget != null)
		return PeerTarget.getParent();
	return super.getParent();
}

public TopWindow getTopWindow() {
	Container so = PeerTarget != null ? PeerTarget.getParent() : getParent();
	for ( ; so != null; so =so.getParent() ) {
		if ( so instanceof TopWindow)
			return (TopWindow)so;
	}
	return null;
}

public int getWidth(){
	return Width;
}

public int getXPos(){
	return XPos;
}

public int getYPos(){
	return YPos;
}

public void gotFocus() {}

public boolean handleEvent( Event evt) {
	if ( PeerTarget != null ){
		boolean ret = PeerTarget.handleEvent( evt);
		if ( ret) return ret;
	}
	return EventHandler.handleEvent( evt);;
}

public boolean hasFocus () {
	return (EventHandler.HasFocus && isShowing() );
}

public boolean imageUpdate ( Image img, int infoflags, int x, int y,
                      int width, int height) {

	if ( infoflags == 3) //( width and height)
		Awt.DefToolkit.prepareImage( img, width, height, this);

	boolean ready = ( (infoflags & ImageObserver.ALLBITS) > 0);

	if (ready) // standard repaint() sometimes seems to blank (causing flicker)
		redraw();

	return !ready;
}

public boolean isEnabled(){
	return !EventHandler.IsDisabled;
}

public void lostFocus() {}

public void mouse1Click( Event evt) {}

public void mouse1DblClick( Event evt) {}

public void mouse1Down( Event evt) {}

public void mouse1Drag( Event evt) {}

public void mouse1Up( Event evt) {}

public void mouse2Click( Event evt) {}

public void mouse2DblClick( Event evt) {}

public void mouse2Down( Event evt) {}

public void mouse2Drag( Event evt){}

public void mouse2Up( Event evt) {}

public void mouseEnter( Event evt) {}

public void mouseExit( Event evt) {}

public void mouseMove( Event evt) {}

public void paint() {
	if ( isShowing() ) {
		Graphics g = getGraphics();
		if ( g != null){
			paint( g);
			g.dispose();
		}
	}
}

public void paint( Graphics g) {

	// infamous ScreenUpdater neutralizer
	if ( RetainPainter != null && RetainPainter.checkPaintSeries() )
		return;

	//windows bug with graphics initialization ( clipRect)
	if ( Awt.AwtToolkit == Awt.TK_WIN) {
		Graphics grr = getGraphics();
		if ( grr != null) {
			FBorder.drawBorder( grr, Width, Height);
			grr.dispose();
		}
	}
	else
		FBorder.drawBorder( g, Width, Height);

	redraw( g);
}

protected void peerEvent ( int id, Object arg) {
	if ( PeerTarget != null)
		PeerTarget.deliverEvent( new Event( PeerTarget, id, arg));
}

protected void posChanged() {}

public void redraw () {
	if ( isShowing() ) {
		Graphics g = getGraphics();
		if ( g != null ) {
			redraw( g);
			g.dispose();
		}
	}
}

protected void redraw( Graphics g) {
	// redraw contents (without borders)
}

public void redrawImmediate(){
	redraw();
	Awt.DefToolkit.sync();
}

public void registerObserver(){
}

public synchronized void reshape( int x, int y, int width, int height) {

	if ( (width < 0) || (height < 0) )
		return;

	boolean change = ((XPos != x) ||
	                  (YPos != y) ||
	                  (Width != width) ||
	                  (Height != height));

	if ( ! change)
		return;

	super.reshape( x, y, width, height);

	XPos   = x;
	YPos   = y;
	Width  = width;
	Height = height;

	DrawRect.reshape( FBorder.Ext, FBorder.Ext,
	                  Width-2*FBorder.Ext, Height-2*FBorder.Ext);

	posChanged();
}

public void setBorder( int bs){
	FBorder.setBorder( bs);

	DrawRect.reshape( FBorder.Ext, FBorder.Ext,
	                  Width-2*FBorder.Ext, Height-2*FBorder.Ext);
}

public void setCursor( int type){
	Frame fr = getFrame();
	if ( fr.getCursorType() != type)
		fr.setCursor( type);
}

public boolean setFocus () {
	if ( canGetFocus() ) {
		requestFocus();
		return true;
	}
	return false;
}

public void setMenu( Menu m){
	if ( m.Handler == null){
		m.assign( EventHandler);
		m.registerKeys( HotKey.Control);
	}
}

void setPeerTarget ( Component peerTarget ) {
	Color fg, bg;
	Font  fnt;

	PeerTarget = peerTarget;

	if ( (fg = peerTarget.getForeground()) != null )
		setForeground( fg);

	if ( (bg = peerTarget.getBackground()) != null )
		setBackground( bg);

	if ( (fnt = peerTarget.getFont()) != null )
		setFont( fnt);
}

public void sync(){
	Awt.DefToolkit.sync();
}

public void unregisterObserver(){
}

public void update( Observable o, Object arg){
	if ( arg instanceof Command )
		((Command)arg).execute();
}

public boolean vKeyInput ( int code, int mod) {
	return false;
}
}
