;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.8/Rgc/ustate.scm            */
;*                                                                     */
;*    Auteur      :  Manuel SERRANO                                    */
;*    Creation    :  Thu Jun 20 11:11:52 1991                          */
;*    Last change :  Mon Jul 10 14:46:01 1995 (serrano)                */
;*                                                                     */
;*    La generation des etats non-compactes                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     Le module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc_ustate
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__rgc                     "Rgc/runtime.scm")
	    (__rgc_transition          "Rgc/transition.scm")
	    (__rgc_automata            "Rgc/automata.scm")
	    (__rgc_optimize            "Rgc/optimize.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (export  (decl-ustate n v a n s)))
		  
;*---------------------------------------------------------------------*/
;*     decl-ustate ...                                                 */
;*---------------------------------------------------------------------*/
(define (decl-ustate state-name vector accept? nb-states state-num)
   ((if (looping? state-num accept?) code-ulooping code-ustate)
       state-name vector accept? nb-states state-num) )

;*---------------------------------------------------------------------*/
;*     code-ulooping ...                                               */
;*---------------------------------------------------------------------*/
(define (code-ulooping state-name vector accept? nb-states state-num)
   `(,state-name ()
		 (case (input-port-read-char input-port)
		    (,(vector-ref vector state-num)
		     (,state-name))
		    ((,@(let loop ( (i 0) )
			   (if (=fx i *rgc-first-char*)
			       '()
			       (cons i (loop (+fx 1 i))))))
		     (input-port-remember-back-ref input-port)
		     (if (input-port-fill-buffer input-port)
			 (,state-name)
			 ,@(accept? state-num)))
		    (else
		     (input-port-remember-back-ref input-port)
		     ,@(accept? state-num)))))

;*---------------------------------------------------------------------*/
;*     code-ustate ...                                                 */
;*---------------------------------------------------------------------*/
(define (code-ustate state-name vector accept? nb-states state-num)
   `(,state-name (mr)
	(case (input-port-read-char input-port)
	   ,@(let for ((i    (-fx nb-states 1))
		       (res '()))
		(if (<fx i 0)
		    (append res `((,(let loop ( (i 0) )
				       (if (=fx i *rgc-first-char*)
					   '()
					   (cons i (loop (+fx 1 i)))))
				   (if (input-port-fill-buffer input-port)
				       (,(state->symbol state-num) mr)
				       mr))
				  (else mr)))
		    (if (not (null? (vector-ref vector i)))
			(for (-fx i 1)
			     (cons
			      (list
			       (vector-ref vector i)
			       (code-> state-num (list 'dummy i) accept?))
			      res))
			(for (-fx i 1)
			     res)))))))



