;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/char.scm                     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec  1 09:29:00 1992                          */
;*    Last change :  Mon May  1 13:52:07 1995 (serrano)                */
;*                                                                     */
;*    On test les caracteres                                           */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module char
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-char)))

;*---------------------------------------------------------------------*/
;*    test-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-char)
   (test-module "char" "char.scm" #f)
   (test "char?" (char? #\a) #t)
   (test "char?" (char? 1) #f)
   (test "char=?" (let ((x #\a)) (char=? x #\a)) #t)
   (test "char=?" (let ((x #\b)) (char=? x #\a)) #f)
   (test "char<?" (let ((x #\b)) (char<? x #\a)) #f)
   (test "char<?" (let ((x #\b)) (char<? #\a x)) #t)
   (test "char>?" (let ((x #\b)) (char>? x #\a)) #t)
   (test "char>?" (let ((x #\b)) (char>? #\a x)) #f)
   (let ((s "t"))
      (test "char>?" (char>? (string-ref s 0) #a127) #t))
   (test "char-ci=?" (let ((x #\A)) (char-ci=? x #\a)) #t)
   (test "char-ci=?" (let ((x #\B)) (char-ci=? x #\a)) #f)
   (test "char-ci<?" (let ((x #\B)) (char-ci<? x #\a)) #f)
   (test "char-ci<?" (let ((x #\B)) (char-ci<? #\a x)) #t)
   (test "char-ci>?" (let ((x #\B)) (char-ci>? x #\a)) #t)
   (test "char-ci>?" (let ((x #\B)) (char-ci>? #\a x)) #f)
   (test "char-alphabetic?" (char-alphabetic? #\a) #t)
   (test "char-alphabetic?" (char-alphabetic? #\0) #f)
   (test "char-numeric?" (char-numeric? #\a) #f)
   (test "char-numeric?" (char-numeric? #\0) #t)
   (test "char-whitespace?" (char-whitespace? #\a) #f)
   (test "char-whitespace?" (char-whitespace? #\space) #t)
   (test "char-upper-case?" (char-upper-case? #\A) #t)
   (test "char-upper-case?" (char-upper-case? #\a) #f)
   (test "char-lower-case?" (char-lower-case? #\A) #f)
   (test "char-lower-case?" (char-lower-case? #\a) #t)
   (test "char->integer" (char->integer #\0) 48)
   (test "char->integer" (char->integer #a200) 200)
   (test "integer->char" (integer->char 48) #\0)
   (test "char-upcase" (char-upcase #\a) #\A)
   (test "char-upcase" (char-upcase #\A) #\A)
   (test "char-downcase" (char-downcase #\a) #\a)
   (test "char-downcase" (char-downcase #\A) #\a)
   (test "unsigned char" (char->integer (integer->char 128)) 128))
   
