;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Tools/dsssl.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  SERRANO Manuel                                    */
;*    Creation    :  Thu Apr  3 14:42:11 1997                          */
;*    Last change :  Tue Apr  8 15:29:59 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Some dsssl goodies.                                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_dsssl
   (import tools_error)
   (export (dsssl-named-constant? obj)
	   (dsssl-defaulted-formal? obj)
	   (dsssl-default-formal obj)
	   (dsssl-find-first-formal obj)
	   (dsssl-formals-skeleton obj)
	   (dsssl-formals-encoding obj)
	   (dsssl-args*->args-list obj)))

;*---------------------------------------------------------------------*/
;*    dsssl-named-constant? ...                                        */
;*    -------------------------------------------------------------    */
;*    Is an object a dsssl named constant (#!optional, #!key or        */
;*    #!rest) ?                                                        */
;*---------------------------------------------------------------------*/
(define (dsssl-named-constant? obj)
   ;; this has to be changed after the bootstrap
   (and (cnst? obj)
	(case (cnst->integer obj)
	   ((#x102 #x103 #x104)
	    #t)
	   (else
	    #f))))

;*---------------------------------------------------------------------*/
;*    dsssl-defaulted-formal? ...                                      */
;*    -------------------------------------------------------------    */
;*    Is an expression a defaulted dsssl argument ?                    */
;*---------------------------------------------------------------------*/
(define (dsssl-defaulted-formal? obj)
   (match-case obj
      ((?- ?-)
       #t)
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    dsssl-default-formal ...                                         */
;*    -------------------------------------------------------------    */
;*    The formal of a dsssl-defaulted-formal expression                */
;*---------------------------------------------------------------------*/
(define (dsssl-default-formal obj)
   (car obj))

;*---------------------------------------------------------------------*/
;*    dsssl-find-first-formal ...                                      */
;*---------------------------------------------------------------------*/
(define (dsssl-find-first-formal args)
   (cond
      ((null? args)
       #f)
      ((not (pair? args))
       (internal-error "dsssl-find-first-formal"
		       "Illegal dsssl formal list"
		       args))
      ((dsssl-named-constant? (car args))
       (dsssl-find-first-formal (cdr args)))
      ((dsssl-defaulted-formal? (car args))
       (dsssl-default-formal (car args)))
      ((not (symbol? (car args)))
       (internal-error "dsssl-find-first-formal"
		       "Illegal dsssl formal list"
		       args))
      (else
       (car args))))
       
;*---------------------------------------------------------------------*/
;*    dsssl-formals-skeleton ...                                       */
;*---------------------------------------------------------------------*/
(define (dsssl-formals-skeleton args)
   (let loop ((args args)
	      (skip #f))
      (cond
	 ((null? args)
	  '())
	 ((not (pair? args))
	  args)
	 ((dsssl-named-constant? (car args))
	  (cons (car args) (loop (cdr args) #t)))
	 (skip
	  (loop (cdr args) skip))
	 (else
	  (cons (car args) (loop (cdr args) skip))))))
	 
;*---------------------------------------------------------------------*/
;*    dsssl-formals-encoding ...                                       */
;*---------------------------------------------------------------------*/
(define (dsssl-formals-encoding args)
   (let loop ((args args)
	      (res  '()))
      (cond
	 ((null? args)
	  res)
	 ((not (pair? args))
	  res)
	 ((dsssl-named-constant? (car args))
	  (loop (cdr args) (cons (car args) res)))
	 (else
	  (loop (cdr args) res)))))
	       
;*---------------------------------------------------------------------*/
;*    dsssl-args*->args-list ...                                       */
;*    cons* --> list                                                   */
;*---------------------------------------------------------------------*/
(define (dsssl-args*->args-list exp)
   (cond
      ((null? exp)
       '())
      ((not (pair? exp))
       (list exp))
      ((dsssl-named-constant? (car exp))
       (let ((arg (dsssl-find-first-formal (cdr exp))))
	  (if arg
	      (list arg)
	      '())))
      ((dsssl-defaulted-formal? (car exp))
       (dsssl-args*->args-list (cdr exp)))
      (else
       (cons (car exp) (dsssl-args*->args-list (cdr exp))))))

